/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final AtomicLong UNIQUE_ID_GEN = new AtomicLong(1L);

    private Utils() {
    }

    public static void rethrowException(Throwable t) {
        Utils.rethrowExceptionInner(t);
    }

    private static <T extends Throwable> void rethrowExceptionInner(Throwable exception) throws T {
        throw exception;
    }

    public static String getCallingMethodDetails() {
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            return e.getStackTrace()[2].toString();
        }
    }

    public static long getUniqueId() {
        return UNIQUE_ID_GEN.incrementAndGet();
    }

    public static String toCamelCase(String text) {
        int length = text.length();
        StringBuilder builder = new StringBuilder(length);
        boolean capitalizeNextChar = false;
        for (int i = 0; i < length; ++i) {
            char theChar = text.charAt(i);
            if (Character.isLetterOrDigit(theChar) || theChar == '.') {
                if (capitalizeNextChar) {
                    builder.append(Character.toUpperCase(theChar));
                    capitalizeNextChar = false;
                    continue;
                }
                builder.append(theChar);
                continue;
            }
            capitalizeNextChar = true;
        }
        return builder.toString();
    }

    public static void logVersions() {
        for (Map.Entry<String, String> titleVersionEntry : Utils.getComponentVersions().entrySet()) {
            LOGGER.info("Using {} {}", (Object)titleVersionEntry.getKey(), (Object)titleVersionEntry.getValue());
        }
    }

    public static Map<String, String> getComponentVersions() {
        HashMap<String, String> componentVersions = new HashMap<String, String>();
        ClassLoader classLoader = Utils.class.getClassLoader();
        if (classLoader != null) {
            try {
                Enumeration<URL> manifests = classLoader.getResources("META-INF/MANIFEST.MF");
                while (manifests.hasMoreElements()) {
                    URL url = manifests.nextElement();
                    InputStream stream = url.openStream();
                    try {
                        String implementationTitle;
                        Manifest manifest = new Manifest(stream);
                        Attributes attributes = manifest.getMainAttributes();
                        if (attributes == null || (implementationTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE)) == null || !implementationTitle.contains("pinot")) continue;
                        String implementationVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        componentVersions.put(implementationTitle, implementationVersion);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return componentVersions;
    }
}

