/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.auth;

import java.util.Collections;
import java.util.Map;
import org.apache.pinot.common.auth.AuthConfig;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.spi.auth.AuthProvider;

public class StaticTokenAuthProvider
implements AuthProvider {
    public static final String HEADER = "header";
    public static final String PREFIX = "prefix";
    public static final String TOKEN = "token";
    protected final String _taskToken;
    protected final Map<String, Object> _requestHeaders;

    public StaticTokenAuthProvider(String token) {
        this._taskToken = token;
        this._requestHeaders = Collections.singletonMap("Authorization", token);
    }

    public StaticTokenAuthProvider(AuthConfig authConfig) {
        String header = AuthProviderUtils.getOrDefault(authConfig, HEADER, "Authorization");
        String prefix = AuthProviderUtils.getOrDefault(authConfig, PREFIX, "Basic");
        String userToken = authConfig.getProperties().get(TOKEN).toString();
        this._taskToken = StaticTokenAuthProvider.makeToken(prefix, userToken);
        this._requestHeaders = Collections.singletonMap(header, this._taskToken);
    }

    public Map<String, Object> getRequestHeaders() {
        return this._requestHeaders;
    }

    public String getTaskToken() {
        return this._taskToken;
    }

    private static String makeToken(String prefix, String token) {
        if (token.startsWith(prefix)) {
            return token;
        }
        return prefix + " " + token;
    }
}

