/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Base64;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.BytesUtils;

public class DataTypeConversionFunctions {
    private DataTypeConversionFunctions() {
    }

    @ScalarFunction
    public static Object cast(Object value, String targetTypeLiteral) {
        try {
            Class<?> clazz = value.getClass();
            Preconditions.checkArgument((boolean)(!clazz.isArray() | clazz == byte[].class), (String)"%s must not be an array type", clazz);
            PinotDataType sourceType = PinotDataType.getSingleValueType(clazz);
            String transformed = targetTypeLiteral.toUpperCase();
            PinotDataType targetDataType = "INT".equals(transformed) ? PinotDataType.INTEGER : ("VARCHAR".equals(transformed) ? PinotDataType.STRING : PinotDataType.valueOf(transformed));
            if (sourceType == PinotDataType.STRING && (targetDataType == PinotDataType.INTEGER || targetDataType == PinotDataType.LONG) && String.valueOf(value).contains(".")) {
                return targetDataType.convert(PinotDataType.DOUBLE.convert(value, sourceType), PinotDataType.DOUBLE);
            }
            return targetDataType.convert(value, sourceType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown data type: " + targetTypeLiteral);
        }
    }

    @ScalarFunction
    public static byte[] bigDecimalToBytes(String number) {
        return BigDecimalUtils.serialize((BigDecimal)new BigDecimal(number));
    }

    @ScalarFunction
    public static String bytesToBigDecimal(byte[] bytes) {
        return BigDecimalUtils.deserialize((byte[])bytes).toString();
    }

    @ScalarFunction
    public static byte[] hexToBytes(String hex) {
        return BytesUtils.toBytes((String)hex);
    }

    @ScalarFunction
    public static String bytesToHex(byte[] bytes) {
        return BytesUtils.toHexString((byte[])bytes);
    }

    @ScalarFunction
    public static byte[] base64Encode(byte[] input) {
        return Base64.getEncoder().encodeToString(input).getBytes();
    }

    @ScalarFunction
    public static byte[] base64Decode(String input) {
        return Base64.getDecoder().decode(input.getBytes());
    }
}

