/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.lineage;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.lineage.LineageEntry;
import org.apache.pinot.common.lineage.LineageEntryState;
import org.apache.pinot.spi.utils.JsonUtils;

public class SegmentLineage {
    private static final String COMMA_SEPARATOR = ",";
    private final String _tableNameWithType;
    private final Map<String, LineageEntry> _lineageEntries;

    public SegmentLineage(String tableNameWithType) {
        this._tableNameWithType = tableNameWithType;
        this._lineageEntries = new HashMap<String, LineageEntry>();
    }

    public SegmentLineage(String tableNameWithType, Map<String, LineageEntry> lineageEntries) {
        this._tableNameWithType = tableNameWithType;
        this._lineageEntries = lineageEntries;
    }

    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public void addLineageEntry(String lineageEntryId, LineageEntry lineageEntry) {
        Preconditions.checkArgument((!this._lineageEntries.containsKey(lineageEntryId) ? 1 : 0) != 0, (Object)String.format("Lineage entry id ('%s') already exists. Please try with the new lineage id", lineageEntryId));
        this._lineageEntries.put(lineageEntryId, lineageEntry);
    }

    public void updateLineageEntry(String lineageEntryId, LineageEntry lineageEntry) {
        Preconditions.checkArgument((boolean)this._lineageEntries.containsKey(lineageEntryId), (Object)String.format("Lineage entry id ('%s') does not exists. Please try with the valid lineage id", lineageEntryId));
        this._lineageEntries.put(lineageEntryId, lineageEntry);
    }

    public LineageEntry getLineageEntry(String lineageEntryId) {
        return this._lineageEntries.get(lineageEntryId);
    }

    public Set<String> getLineageEntryIds() {
        return new HashSet<String>(this._lineageEntries.keySet());
    }

    public void deleteLineageEntry(String lineageEntryId) {
        this._lineageEntries.remove(lineageEntryId);
    }

    public static SegmentLineage fromZNRecord(ZNRecord record) {
        String tableNameWithType = record.getId();
        HashMap<String, LineageEntry> lineageEntries = new HashMap<String, LineageEntry>();
        Map listFields = record.getListFields();
        for (Map.Entry listField : listFields.entrySet()) {
            String lineageId = (String)listField.getKey();
            List value = (List)listField.getValue();
            Preconditions.checkState((value.size() == 4 ? 1 : 0) != 0);
            List<String> segmentsFrom = Arrays.asList(StringUtils.split((String)((String)value.get(0)), (String)COMMA_SEPARATOR));
            List<String> segmentsTo = Arrays.asList(StringUtils.split((String)((String)value.get(1)), (String)COMMA_SEPARATOR));
            LineageEntryState state = LineageEntryState.valueOf((String)value.get(2));
            long timestamp = Long.parseLong((String)value.get(3));
            lineageEntries.put(lineageId, new LineageEntry(segmentsFrom, segmentsTo, state, timestamp));
        }
        return new SegmentLineage(tableNameWithType, lineageEntries);
    }

    public ZNRecord toZNRecord() {
        ZNRecord znRecord = new ZNRecord(this._tableNameWithType);
        for (Map.Entry<String, LineageEntry> entry : this._lineageEntries.entrySet()) {
            LineageEntry lineageEntry = entry.getValue();
            String segmentsFrom = String.join((CharSequence)COMMA_SEPARATOR, lineageEntry.getSegmentsFrom());
            String segmentsTo = String.join((CharSequence)COMMA_SEPARATOR, lineageEntry.getSegmentsTo());
            String state = lineageEntry.getState().toString();
            String timestamp = Long.toString(lineageEntry.getTimestamp());
            List<String> listEntry = Arrays.asList(segmentsFrom, segmentsTo, state, timestamp);
            znRecord.setListField(entry.getKey(), listEntry);
        }
        return znRecord;
    }

    public ObjectNode toJsonObject() {
        ObjectNode jsonObject = JsonUtils.newObjectNode();
        jsonObject.put("tableNameWithType", this._tableNameWithType);
        LinkedHashMap sortedLineageEntries = new LinkedHashMap();
        this._lineageEntries.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingLong(LineageEntry::getTimestamp))).forEachOrdered(x -> sortedLineageEntries.put((String)x.getKey(), (LineageEntry)x.getValue()));
        jsonObject.set("lineageEntries", JsonUtils.objectToJsonNode(sortedLineageEntries));
        return jsonObject;
    }
}

