/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context.predicate;

import java.math.BigDecimal;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.predicate.BasePredicate;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

public abstract class BaseInPredicate
extends BasePredicate {
    protected final List<String> _values;
    private int[] _intValues;
    private long[] _longValues;
    private float[] _floatValues;
    private double[] _doubleValues;
    private BigDecimal[] _bigDecimalValues;
    private int[] _booleanValues;
    private long[] _timestampValues;
    private ByteArray[] _bytesValues;

    public BaseInPredicate(ExpressionContext lhs, List<String> values) {
        super(lhs);
        this._values = values;
    }

    public List<String> getValues() {
        return this._values;
    }

    public int[] getIntValues() {
        int[] intValues = this._intValues;
        if (intValues == null) {
            int numValues = this._values.size();
            intValues = new int[numValues];
            for (int i = 0; i < numValues; ++i) {
                intValues[i] = Integer.parseInt(this._values.get(i));
            }
            this._intValues = intValues;
        }
        return intValues;
    }

    public long[] getLongValues() {
        long[] longValues = this._longValues;
        if (longValues == null) {
            int numValues = this._values.size();
            longValues = new long[numValues];
            for (int i = 0; i < numValues; ++i) {
                longValues[i] = Long.parseLong(this._values.get(i));
            }
            this._longValues = longValues;
        }
        return longValues;
    }

    public float[] getFloatValues() {
        float[] floatValues = this._floatValues;
        if (floatValues == null) {
            int numValues = this._values.size();
            floatValues = new float[numValues];
            for (int i = 0; i < numValues; ++i) {
                floatValues[i] = Float.parseFloat(this._values.get(i));
            }
            this._floatValues = floatValues;
        }
        return floatValues;
    }

    public double[] getDoubleValues() {
        double[] doubleValues = this._doubleValues;
        if (doubleValues == null) {
            int numValues = this._values.size();
            doubleValues = new double[numValues];
            for (int i = 0; i < numValues; ++i) {
                doubleValues[i] = Double.parseDouble(this._values.get(i));
            }
            this._doubleValues = doubleValues;
        }
        return doubleValues;
    }

    public BigDecimal[] getBigDecimalValues() {
        BigDecimal[] bigDecimalValues = this._bigDecimalValues;
        if (bigDecimalValues == null) {
            int numValues = this._values.size();
            bigDecimalValues = new BigDecimal[numValues];
            for (int i = 0; i < numValues; ++i) {
                bigDecimalValues[i] = new BigDecimal(this._values.get(i));
            }
            this._bigDecimalValues = bigDecimalValues;
        }
        return bigDecimalValues;
    }

    public int[] getBooleanValues() {
        int[] booleanValues = this._booleanValues;
        if (booleanValues == null) {
            int numValues = this._values.size();
            booleanValues = new int[numValues];
            for (int i = 0; i < numValues; ++i) {
                booleanValues[i] = BooleanUtils.toInt((String)this._values.get(i));
            }
            this._booleanValues = booleanValues;
        }
        return booleanValues;
    }

    public long[] getTimestampValues() {
        long[] timestampValues = this._timestampValues;
        if (timestampValues == null) {
            int numValues = this._values.size();
            timestampValues = new long[numValues];
            for (int i = 0; i < numValues; ++i) {
                timestampValues[i] = TimestampUtils.toMillisSinceEpoch((String)this._values.get(i));
            }
            this._timestampValues = timestampValues;
        }
        return timestampValues;
    }

    public ByteArray[] getBytesValues() {
        ByteArray[] bigDecimalValues = this._bytesValues;
        if (bigDecimalValues == null) {
            int numValues = this._values.size();
            bigDecimalValues = new ByteArray[numValues];
            for (int i = 0; i < numValues; ++i) {
                bigDecimalValues[i] = BytesUtils.toByteArray((String)this._values.get(i));
            }
            this._bytesValues = bigDecimalValues;
        }
        return bigDecimalValues;
    }
}

