/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class FileUtils {
    private FileUtils() {
    }

    public static void moveFileWithOverwrite(File srcFile, File destFile) throws IOException {
        if (destFile.exists()) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)destFile);
        }
        org.apache.commons.io.FileUtils.moveFile((File)srcFile, (File)destFile);
    }

    public static void transferBytes(FileChannel src, long position, long count, FileChannel dest) throws IOException {
        long numBytesTransferred;
        while ((numBytesTransferred = src.transferTo(position, count, dest)) < count) {
            position += numBytesTransferred;
            count -= numBytesTransferred;
        }
    }

    public static void close(Iterable<? extends Closeable> closeables) throws IOException {
        IOException topLevelException = null;
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException e) {
                if (topLevelException == null) {
                    topLevelException = e;
                    continue;
                }
                if (e == topLevelException) continue;
                topLevelException.addSuppressed(e);
            }
        }
        if (topLevelException != null) {
            throw topLevelException;
        }
    }

    public static void close(Closeable ... closeables) throws IOException {
        FileUtils.close(Arrays.asList(closeables));
    }
}

