/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.Obfuscator;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"systemConfig", "runtimeConfig", "pinotConfig", "jvmConfig"})
public class PinotAppConfigs {
    private static final String UNKNOWN_VALUE = "-";
    @JsonProperty(value="systemConfig")
    private SystemConfig _systemConfig;
    @JsonProperty(value="jvmConfig")
    private JVMConfig _jvmConfig;
    @JsonProperty(value="runtimeConfig")
    private RuntimeConfig _runtimeConfig;
    @JsonProperty(value="pinotConfig")
    private Map<String, Object> _pinotConfig;

    @JsonCreator
    public PinotAppConfigs() {
    }

    public PinotAppConfigs(PinotConfiguration pinotConfig) {
        this._systemConfig = this.buildSystemConfig();
        this._jvmConfig = this.buildJVMConfig();
        this._runtimeConfig = this.buildRuntimeConfig();
        this._pinotConfig = pinotConfig.toMap();
    }

    public SystemConfig getSystemConfig() {
        return this._systemConfig;
    }

    public JVMConfig getJvmConfig() {
        return this._jvmConfig;
    }

    public RuntimeConfig getRuntimeConfig() {
        return this._runtimeConfig;
    }

    public Map<String, Object> getPinotConfig() {
        return this._pinotConfig;
    }

    private SystemConfig buildSystemConfig() {
        SystemConfig systemConfig;
        java.lang.management.OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (osMXBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunOsMXBean = (OperatingSystemMXBean)osMXBean;
            systemConfig = new SystemConfig(osMXBean.getArch(), osMXBean.getName(), osMXBean.getVersion(), osMXBean.getAvailableProcessors(), FileUtils.byteCountToDisplaySize((long)sunOsMXBean.getTotalPhysicalMemorySize()), FileUtils.byteCountToDisplaySize((long)sunOsMXBean.getFreePhysicalMemorySize()), FileUtils.byteCountToDisplaySize((long)sunOsMXBean.getTotalSwapSpaceSize()), FileUtils.byteCountToDisplaySize((long)sunOsMXBean.getFreeSwapSpaceSize()));
        } else {
            systemConfig = new SystemConfig(osMXBean.getArch(), osMXBean.getName(), osMXBean.getVersion(), osMXBean.getAvailableProcessors(), UNKNOWN_VALUE, UNKNOWN_VALUE, UNKNOWN_VALUE, UNKNOWN_VALUE);
        }
        return systemConfig;
    }

    private JVMConfig buildJVMConfig() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        String bootClassPath = runtimeMXBean.isBootClassPathSupported() ? runtimeMXBean.getBootClassPath() : null;
        return new JVMConfig(runtimeMXBean.getInputArguments(), runtimeMXBean.getLibraryPath(), bootClassPath, runtimeMXBean.getSystemProperties(), System.getenv(), garbageCollectorMXBeans.stream().map(MemoryManagerMXBean::getName).collect(Collectors.toList()));
    }

    private RuntimeConfig buildRuntimeConfig() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return new RuntimeConfig(threadMXBean.getTotalStartedThreadCount(), threadMXBean.getThreadCount(), FileUtils.byteCountToDisplaySize((long)heapMemoryUsage.getMax()), FileUtils.byteCountToDisplaySize((long)heapMemoryUsage.getUsed()));
    }

    public String toJSONString() {
        try {
            return JsonUtils.objectToPrettyString((Object)new Obfuscator().toJson((Object)this));
        }
        catch (JsonProcessingException e) {
            return e.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PinotAppConfigs that = (PinotAppConfigs)o;
        return Objects.equals(this._systemConfig, that._systemConfig) && Objects.equals(this._jvmConfig, that._jvmConfig) && Objects.equals(this._runtimeConfig, that._runtimeConfig) && Objects.equals(this._pinotConfig, that._pinotConfig);
    }

    public int hashCode() {
        return Objects.hash(this._systemConfig, this._jvmConfig, this._runtimeConfig, this._pinotConfig);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPropertyOrder(value={"args", "garbageCollectors", "envVariables", "libraryPath", "bootClassPath"})
    public static class JVMConfig {
        private final List<String> _args;
        private final String _libraryPath;
        private final String _bootClassPath;
        private final Map<String, String> _envVariables;
        private final Map<String, String> _systemProperties;
        private final List<String> _garbageCollectors;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JVMConfig jvmConfig = (JVMConfig)o;
            return Objects.equals(this._args, jvmConfig._args) && Objects.equals(this._libraryPath, jvmConfig._libraryPath) && Objects.equals(this._bootClassPath, jvmConfig._bootClassPath) && Objects.equals(this._envVariables, jvmConfig._envVariables) && Objects.equals(this._systemProperties, jvmConfig._systemProperties) && Objects.equals(this._garbageCollectors, jvmConfig._garbageCollectors);
        }

        public int hashCode() {
            return Objects.hash(this._args, this._libraryPath, this._bootClassPath, this._envVariables, this._systemProperties, this._garbageCollectors);
        }

        @JsonCreator
        public JVMConfig(@JsonProperty(value="args") List<String> args, @JsonProperty(value="libraryPath") String libraryPath, @JsonProperty(value="bootClassPath") String bootClassPath, @JsonProperty(value="systemProperties") Map<String, String> systemProperties, @JsonProperty(value="envVariables") Map<String, String> envVariables, @JsonProperty(value="garbageCollectors") List<String> garbageCollectors) {
            this._args = args;
            this._libraryPath = libraryPath;
            this._bootClassPath = bootClassPath;
            this._envVariables = envVariables;
            this._systemProperties = systemProperties;
            this._garbageCollectors = garbageCollectors;
        }

        public List<String> getArgs() {
            return this._args;
        }

        public String getLibraryPath() {
            return this._libraryPath;
        }

        public String getBootClassPath() {
            return this._bootClassPath;
        }

        public Map<String, String> getEnvVariables() {
            return this._envVariables;
        }

        public Map<String, String> getSystemProperties() {
            return this._systemProperties;
        }

        public List<String> getGarbageCollectors() {
            return this._garbageCollectors;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RuntimeConfig {
        private final long _numTotalThreads;
        private final int _numCurrentThreads;
        private final String _maxHeapSize;
        private final String _currentHeapSize;

        @JsonCreator
        public RuntimeConfig(@JsonProperty(value="numTotalThreads") long numTotalThreads, @JsonProperty(value="numCurrentThreads") int numCurrentThreads, @JsonProperty(value="maxHeapSize") String maxHeapSize, @JsonProperty(value="currentHeapSize") String currentHeapSize) {
            this._numTotalThreads = numTotalThreads;
            this._numCurrentThreads = numCurrentThreads;
            this._maxHeapSize = maxHeapSize;
            this._currentHeapSize = currentHeapSize;
        }

        public long getNumTotalThreads() {
            return this._numTotalThreads;
        }

        public int getNumCurrentThreads() {
            return this._numCurrentThreads;
        }

        public String getMaxHeapSize() {
            return this._maxHeapSize;
        }

        public String getCurrentHeapSize() {
            return this._currentHeapSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuntimeConfig that = (RuntimeConfig)o;
            return this._numTotalThreads == that._numTotalThreads && this._numCurrentThreads == that._numCurrentThreads && Objects.equals(this._maxHeapSize, that._maxHeapSize) && Objects.equals(this._currentHeapSize, that._currentHeapSize);
        }

        public int hashCode() {
            return Objects.hash(this._numTotalThreads, this._numCurrentThreads, this._maxHeapSize, this._currentHeapSize);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SystemConfig {
        private final String _arch;
        private final String _name;
        private final String _version;
        private final int _availableProcessors;
        private final String _totalPhysicalMemory;
        private final String _freePhysicalMemory;
        private final String _totalSwapSpace;
        private final String _freeSwapSpace;

        @JsonCreator
        public SystemConfig(@JsonProperty(value="arch") String arch, @JsonProperty(value="name") String name, @JsonProperty(value="version") String version, @JsonProperty(value="availableProcessors") int availableProcessors, @JsonProperty(value="totalPhysicalMemory") String totalPhysicalMemory, @JsonProperty(value="freePhysicalMemory") String freePhysicalMemory, @JsonProperty(value="totalSwapSpace") String totalSwapSpace, @JsonProperty(value="freeSwapSpace") String freeSwapSpace) {
            this._arch = arch;
            this._name = name;
            this._version = version;
            this._availableProcessors = availableProcessors;
            this._totalPhysicalMemory = totalPhysicalMemory;
            this._freePhysicalMemory = freePhysicalMemory;
            this._totalSwapSpace = totalSwapSpace;
            this._freeSwapSpace = freeSwapSpace;
        }

        public String getArch() {
            return this._arch;
        }

        public String getName() {
            return this._name;
        }

        public String getVersion() {
            return this._version;
        }

        public int getAvailableProcessors() {
            return this._availableProcessors;
        }

        public String getTotalPhysicalMemory() {
            return this._totalPhysicalMemory;
        }

        public String getFreePhysicalMemory() {
            return this._freePhysicalMemory;
        }

        public String getTotalSwapSpace() {
            return this._totalSwapSpace;
        }

        public String getFreeSwapSpace() {
            return this._freeSwapSpace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SystemConfig that = (SystemConfig)o;
            return this._availableProcessors == that._availableProcessors && Objects.equals(this._arch, that._arch) && Objects.equals(this._name, that._name) && Objects.equals(this._version, that._version) && Objects.equals(this._totalPhysicalMemory, that._totalPhysicalMemory) && Objects.equals(this._freePhysicalMemory, that._freePhysicalMemory) && Objects.equals(this._totalSwapSpace, that._totalSwapSpace) && Objects.equals(this._freeSwapSpace, that._freeSwapSpace);
        }

        public int hashCode() {
            return Objects.hash(this._arch, this._name, this._version, this._availableProcessors, this._totalPhysicalMemory, this._freePhysicalMemory, this._totalSwapSpace, this._freeSwapSpace);
        }
    }
}

