/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class CompileTimeFunctionsInvoker
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        Expression expression;
        int i;
        for (i = 0; i < pinotQuery.getSelectListSize(); ++i) {
            expression = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(pinotQuery.getSelectList().get(i));
            pinotQuery.getSelectList().set(i, expression);
        }
        for (i = 0; i < pinotQuery.getGroupByListSize(); ++i) {
            expression = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(pinotQuery.getGroupByList().get(i));
            pinotQuery.getGroupByList().set(i, expression);
        }
        for (i = 0; i < pinotQuery.getOrderByListSize(); ++i) {
            expression = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(pinotQuery.getOrderByList().get(i));
            pinotQuery.getOrderByList().set(i, expression);
        }
        Expression filterExpression = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(pinotQuery.getFilterExpression());
        pinotQuery.setFilterExpression(filterExpression);
        Expression havingExpression = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(pinotQuery.getHavingExpression());
        pinotQuery.setHavingExpression(havingExpression);
        return pinotQuery;
    }

    protected static Expression invokeCompileTimeFunctionExpression(@Nullable Expression expression) {
        FunctionInfo functionInfo;
        if (expression == null || expression.getFunctionCall() == null) {
            return expression;
        }
        Function function = expression.getFunctionCall();
        List<Expression> operands = function.getOperands();
        int numOperands = operands.size();
        boolean compilable = true;
        for (int i = 0; i < numOperands; ++i) {
            Expression operand = CompileTimeFunctionsInvoker.invokeCompileTimeFunctionExpression(operands.get(i));
            if (operand.getLiteral() == null) {
                compilable = false;
            }
            operands.set(i, operand);
        }
        String functionName = function.getOperator();
        if (compilable && (functionInfo = FunctionRegistry.getFunctionInfo(functionName, numOperands)) != null) {
            Object[] arguments = new Object[numOperands];
            for (int i = 0; i < numOperands; ++i) {
                arguments[i] = function.getOperands().get(i).getLiteral().getFieldValue();
            }
            try {
                FunctionInvoker invoker = new FunctionInvoker(functionInfo);
                invoker.convertTypes(arguments);
                Object result = invoker.invoke(arguments);
                return RequestUtils.getLiteralExpression(result);
            }
            catch (Exception e) {
                throw new SqlCompilationException("Caught exception while invoking method: " + functionInfo.getMethod() + " with arguments: " + Arrays.toString(arguments), e);
            }
        }
        return expression;
    }
}

