/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@Metrics(name="DataNodeVolume", about="DataNode Volume metrics", context="dfs")
public class DataNodeVolumeMetrics {
    private final MetricsRegistry registry = new MetricsRegistry("FsVolume");
    @Metric(value={"number of metadata operations"})
    private MutableCounterLong totalMetadataOperations;
    @Metric(value={"metadata operation rate"})
    private MutableRate metadataOperationRate;
    private MutableQuantiles[] metadataOperationLatencyQuantiles;
    @Metric(value={"number of data file io operations"})
    private MutableCounterLong totalDataFileIos;
    @Metric(value={"data file io operation rate"})
    private MutableRate dataFileIoRate;
    private MutableQuantiles[] dataFileIoLatencyQuantiles;
    @Metric(value={"file io flush rate"})
    private MutableRate flushIoRate;
    private MutableQuantiles[] flushIoLatencyQuantiles;
    @Metric(value={"file io sync rate"})
    private MutableRate syncIoRate;
    private MutableQuantiles[] syncIoLatencyQuantiles;
    @Metric(value={"file io read rate"})
    private MutableRate readIoRate;
    private MutableQuantiles[] readIoLatencyQuantiles;
    @Metric(value={"file io write rate"})
    private MutableRate writeIoRate;
    private MutableQuantiles[] writeIoLatencyQuantiles;
    @Metric(value={"number of file io errors"})
    private MutableCounterLong totalFileIoErrors;
    @Metric(value={"file io error rate"})
    private MutableRate fileIoErrorRate;
    private final String name;
    private final MetricsSystem ms;

    public long getTotalMetadataOperations() {
        return this.totalMetadataOperations.value();
    }

    public long getMetadataOperationSampleCount() {
        return this.metadataOperationRate.lastStat().numSamples();
    }

    public double getMetadataOperationMean() {
        return this.metadataOperationRate.lastStat().mean();
    }

    public double getMetadataOperationStdDev() {
        return this.metadataOperationRate.lastStat().stddev();
    }

    public long getTotalDataFileIos() {
        return this.totalDataFileIos.value();
    }

    public long getDataFileIoSampleCount() {
        return this.dataFileIoRate.lastStat().numSamples();
    }

    public double getDataFileIoMean() {
        return this.dataFileIoRate.lastStat().mean();
    }

    public double getDataFileIoStdDev() {
        return this.dataFileIoRate.lastStat().stddev();
    }

    public long getFlushIoSampleCount() {
        return this.flushIoRate.lastStat().numSamples();
    }

    public double getFlushIoMean() {
        return this.flushIoRate.lastStat().mean();
    }

    public double getFlushIoStdDev() {
        return this.flushIoRate.lastStat().stddev();
    }

    public long getSyncIoSampleCount() {
        return this.syncIoRate.lastStat().numSamples();
    }

    public double getSyncIoMean() {
        return this.syncIoRate.lastStat().mean();
    }

    public double getSyncIoStdDev() {
        return this.syncIoRate.lastStat().stddev();
    }

    public long getReadIoSampleCount() {
        return this.readIoRate.lastStat().numSamples();
    }

    public double getReadIoMean() {
        return this.readIoRate.lastStat().mean();
    }

    public double getReadIoStdDev() {
        return this.readIoRate.lastStat().stddev();
    }

    public long getWriteIoSampleCount() {
        return this.syncIoRate.lastStat().numSamples();
    }

    public double getWriteIoMean() {
        return this.syncIoRate.lastStat().mean();
    }

    public double getWriteIoStdDev() {
        return this.syncIoRate.lastStat().stddev();
    }

    public long getTotalFileIoErrors() {
        return this.totalFileIoErrors.value();
    }

    public long getFileIoErrorSampleCount() {
        return this.fileIoErrorRate.lastStat().numSamples();
    }

    public double getFileIoErrorMean() {
        return this.fileIoErrorRate.lastStat().mean();
    }

    public double getFileIoErrorStdDev() {
        return this.fileIoErrorRate.lastStat().stddev();
    }

    public DataNodeVolumeMetrics(MetricsSystem metricsSystem, String volumeName, int[] intervals) {
        this.ms = metricsSystem;
        this.name = volumeName;
        int len = intervals.length;
        this.metadataOperationLatencyQuantiles = new MutableQuantiles[len];
        this.dataFileIoLatencyQuantiles = new MutableQuantiles[len];
        this.flushIoLatencyQuantiles = new MutableQuantiles[len];
        this.syncIoLatencyQuantiles = new MutableQuantiles[len];
        this.readIoLatencyQuantiles = new MutableQuantiles[len];
        this.writeIoLatencyQuantiles = new MutableQuantiles[len];
        for (int i = 0; i < len; ++i) {
            int interval = intervals[i];
            this.metadataOperationLatencyQuantiles[i] = this.registry.newQuantiles("metadataOperationLatency" + interval + "s", "Meatadata Operation Latency in ms", "ops", "latency", interval);
            this.dataFileIoLatencyQuantiles[i] = this.registry.newQuantiles("dataFileIoLatency" + interval + "s", "Data File Io Latency in ms", "ops", "latency", interval);
            this.flushIoLatencyQuantiles[i] = this.registry.newQuantiles("flushIoLatency" + interval + "s", "Data flush Io Latency in ms", "ops", "latency", interval);
            this.syncIoLatencyQuantiles[i] = this.registry.newQuantiles("syncIoLatency" + interval + "s", "Data sync Io Latency in ms", "ops", "latency", interval);
            this.readIoLatencyQuantiles[i] = this.registry.newQuantiles("readIoLatency" + interval + "s", "Data read Io Latency in ms", "ops", "latency", interval);
            this.writeIoLatencyQuantiles[i] = this.registry.newQuantiles("writeIoLatency" + interval + "s", "Data write Io Latency in ms", "ops", "latency", interval);
        }
    }

    public static DataNodeVolumeMetrics create(Configuration conf, String volumeName) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        String name = "DataNodeVolume-" + (volumeName.isEmpty() ? "UndefinedDataNodeVolume" + ThreadLocalRandom.current().nextInt() : volumeName.replace(':', '-'));
        int[] intervals = conf.getInts("dfs.metrics.percentiles.intervals");
        return ms.register(name, null, new DataNodeVolumeMetrics(ms, name, intervals));
    }

    public String name() {
        return this.name;
    }

    public void unRegister() {
        this.ms.unregisterSource(this.name);
    }

    public void addMetadastaOperationLatency(long latency) {
        this.totalMetadataOperations.incr();
        this.metadataOperationRate.add(latency);
        for (MutableQuantiles q : this.metadataOperationLatencyQuantiles) {
            q.add(latency);
        }
    }

    public void addDataFileIoLatency(long latency) {
        this.totalDataFileIos.incr();
        this.dataFileIoRate.add(latency);
        for (MutableQuantiles q : this.dataFileIoLatencyQuantiles) {
            q.add(latency);
        }
    }

    public void addSyncIoLatency(long latency) {
        this.syncIoRate.add(latency);
        for (MutableQuantiles q : this.syncIoLatencyQuantiles) {
            q.add(latency);
        }
    }

    public void addFlushIoLatency(long latency) {
        this.flushIoRate.add(latency);
        for (MutableQuantiles q : this.flushIoLatencyQuantiles) {
            q.add(latency);
        }
    }

    public void addReadIoLatency(long latency) {
        this.readIoRate.add(latency);
        for (MutableQuantiles q : this.readIoLatencyQuantiles) {
            q.add(latency);
        }
    }

    public void addWriteIoLatency(long latency) {
        this.writeIoRate.add(latency);
        for (MutableQuantiles q : this.writeIoLatencyQuantiles) {
            q.add(latency);
        }
    }

    public void addFileIoError(long latency) {
        this.totalFileIoErrors.incr();
        this.metadataOperationRate.add(latency);
    }
}

