/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.trino2rel;

import com.linkedin.coral.trino.trino2rel.OperatorTransformer;
import java.util.Map;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;

public class Trino2CoralOperatorTransformerMapUtils {
    private Trino2CoralOperatorTransformerMapUtils() {
    }

    static void createTransformerMapEntry(Map<String, OperatorTransformer> transformerMap, SqlOperator trinoOp, int numOperands, String calciteOperatorName) {
        Trino2CoralOperatorTransformerMapUtils.createTransformerMapEntry(transformerMap, trinoOp, numOperands, calciteOperatorName, null, null);
    }

    static void createTransformerMapEntry(Map<String, OperatorTransformer> transformerMap, SqlOperator trinoOp, int numOperands, String calciteOperatorName, String operandTransformer, String resultTransformer) {
        Trino2CoralOperatorTransformerMapUtils.createTransformerMapEntry(transformerMap, trinoOp, numOperands, Trino2CoralOperatorTransformerMapUtils.createOperator(calciteOperatorName, trinoOp.getReturnTypeInference(), trinoOp.getOperandTypeChecker()), operandTransformer, resultTransformer);
    }

    static void createTransformerMapEntry(Map<String, OperatorTransformer> transformerMap, SqlOperator trinoOp, int numOperands, SqlOperator calciteSqlOperator, String operandTransformer, String resultTransformer) {
        transformerMap.put(Trino2CoralOperatorTransformerMapUtils.getKey(trinoOp.getName(), numOperands), OperatorTransformer.of(trinoOp.getName(), calciteSqlOperator, operandTransformer, resultTransformer, null));
    }

    static SqlOperator createOperator(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        return new SqlUserDefinedFunction(new SqlIdentifier(functionName, SqlParserPos.ZERO), returnTypeInference, null, operandTypeChecker, null, null);
    }

    static String getKey(String trinoOpName, int numOperands) {
        return trinoOpName + "_" + numOperands;
    }
}

