/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;

public class FloatColumnReader
extends PrimitiveColumnReader {
    public FloatColumnReader(PrimitiveField field) {
        super(field);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (type == RealType.REAL) {
            type.writeLong(blockBuilder, (long)Float.floatToRawIntBits(this.valuesReader.readFloat()));
        } else if (type == DoubleType.DOUBLE) {
            type.writeDouble(blockBuilder, (double)this.valuesReader.readFloat());
        } else {
            throw new VerifyError("Unsupported type " + type);
        }
    }
}

