/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.reader;

import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.Stream;
import io.trino.orc.reader.ColumnReader;
import io.trino.orc.stream.BooleanInputStream;
import io.trino.orc.stream.ByteArrayInputStream;
import io.trino.orc.stream.InputStreamSource;
import io.trino.orc.stream.InputStreamSources;
import io.trino.orc.stream.MissingInputStreamSource;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class UuidColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(UuidColumnReader.class);
    private static final int ONE_GIGABYTE = Math.toIntExact(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes());
    private static final VarHandle LONG_ARRAY_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private final OrcColumn column;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<ByteArrayInputStream> dataByteSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    @Nullable
    private ByteArrayInputStream dataStream;
    private boolean rowGroupOpen;

    public UuidColumnReader(OrcColumn column) {
        this.column = Objects.requireNonNull(column, "column is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            this.skipToReadOffset();
            this.readOffset = 0;
        }
        if (this.dataStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            Block nullValueBlock = this.createAllNullsBlock();
            this.nextBatchSize = 0;
            return nullValueBlock;
        }
        boolean[] isNullVector = null;
        int nullCount = 0;
        if (this.presentStream != null) {
            isNullVector = new boolean[this.nextBatchSize];
            nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNullVector);
            if (nullCount == this.nextBatchSize) {
                Block nullValueBlock = this.createAllNullsBlock();
                this.nextBatchSize = 0;
                return nullValueBlock;
            }
            if (nullCount == 0) {
                isNullVector = null;
            }
        }
        int numberOfLongValues = Math.toIntExact((long)this.nextBatchSize * 2L);
        int totalByteLength = Math.toIntExact((long)numberOfLongValues * 8L);
        int currentBatchSize = this.nextBatchSize;
        this.nextBatchSize = 0;
        if (totalByteLength == 0) {
            return new Int128ArrayBlock(currentBatchSize, Optional.empty(), new long[0]);
        }
        if (totalByteLength > ONE_GIGABYTE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Values in column \"%s\" are too large to process for Trino. %s column values are larger than 1GB [%s]", this.column.getPath(), this.nextBatchSize, this.column.getOrcDataSourceId()));
        }
        if (this.dataStream == null) {
            throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
        }
        if (isNullVector == null) {
            long[] values = this.readNonNullLongs(numberOfLongValues);
            return new Int128ArrayBlock(currentBatchSize, Optional.empty(), values);
        }
        int nonNullCount = currentBatchSize - nullCount;
        long[] values = this.readNullableLongs(isNullVector, nonNullCount);
        return new Int128ArrayBlock(currentBatchSize, Optional.of(isNullVector), values);
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataByteSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataByteSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.DATA, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    @Override
    public void close() {
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    private void skipToReadOffset() throws IOException {
        int dataReadOffset = this.readOffset;
        if (this.presentStream != null) {
            dataReadOffset = this.presentStream.countBitsSet(this.readOffset);
        }
        if (dataReadOffset > 0) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
            }
            long dataSkipSize = (long)dataReadOffset * 2L * 8L;
            this.dataStream.skip(dataSkipSize);
        }
    }

    private long[] readNullableLongs(boolean[] isNullVector, int nonNullCount) throws IOException {
        byte[] data = new byte[nonNullCount * 2 * 8];
        this.dataStream.next(data, 0, data.length);
        int[] offsets = new int[isNullVector.length];
        int offsetPosition = 0;
        for (int i = 0; i < isNullVector.length; ++i) {
            offsets[i] = Math.min(offsetPosition * 2 * 8, data.length - 16);
            offsetPosition += isNullVector[i] ? 0 : 1;
        }
        long[] values = new long[isNullVector.length * 2];
        for (int i = 0; i < isNullVector.length; ++i) {
            int isNonNull = isNullVector[i] ? 0 : 1;
            values[i * 2] = LONG_ARRAY_HANDLE.get(data, offsets[i]) * (long)isNonNull;
            values[i * 2 + 1] = LONG_ARRAY_HANDLE.get(data, offsets[i] + 8) * (long)isNonNull;
        }
        return values;
    }

    private long[] readNonNullLongs(int valueCount) throws IOException {
        byte[] data = new byte[valueCount * 8];
        this.dataStream.next(data, 0, data.length);
        long[] values = new long[valueCount];
        for (int i = 0; i < valueCount; ++i) {
            values[i] = LONG_ARRAY_HANDLE.get(data, i * 8);
        }
        return values;
    }

    private Block createAllNullsBlock() {
        return RunLengthEncodedBlock.create((Block)new Int128ArrayBlock(1, Optional.of(new boolean[]{true}), new long[2]), (int)this.nextBatchSize);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataByteSource.openStream();
        this.rowGroupOpen = true;
    }
}

