/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.hive.thrift.metastore.StorageDescriptor;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HiveBucketProperty {
    private final List<String> bucketedBy;
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int bucketCount;
    private final List<SortingColumn> sortedBy;

    @JsonCreator
    public HiveBucketProperty(@JsonProperty(value="bucketedBy") List<String> bucketedBy, @JsonProperty(value="bucketingVersion") HiveBucketing.BucketingVersion bucketingVersion, @JsonProperty(value="bucketCount") int bucketCount, @JsonProperty(value="sortedBy") List<SortingColumn> sortedBy) {
        this.bucketedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketedBy, "bucketedBy is null"));
        this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        this.bucketCount = bucketCount;
        this.sortedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortedBy, "sortedBy is null"));
    }

    public static Optional<HiveBucketProperty> fromStorageDescriptor(Map<String, String> tableParameters, StorageDescriptor storageDescriptor, String tablePartitionName) {
        boolean numBucketsSet;
        boolean bucketColsSet = storageDescriptor.isSetBucketCols() && !storageDescriptor.getBucketCols().isEmpty();
        boolean bl = numBucketsSet = storageDescriptor.isSetNumBuckets() && storageDescriptor.getNumBuckets() > 0;
        if (!numBucketsSet) {
            return Optional.empty();
        }
        if (!bucketColsSet) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has 'numBuckets' set, but 'bucketCols' is not set: " + tablePartitionName);
        }
        Object sortedBy = ImmutableList.of();
        if (storageDescriptor.isSetSortCols()) {
            sortedBy = (List)storageDescriptor.getSortCols().stream().map(order -> SortingColumn.fromMetastoreApiOrder(order, tablePartitionName)).collect(ImmutableList.toImmutableList());
        }
        HiveBucketing.BucketingVersion bucketingVersion = HiveBucketing.getBucketingVersion(tableParameters);
        return Optional.of(new HiveBucketProperty(storageDescriptor.getBucketCols(), bucketingVersion, storageDescriptor.getNumBuckets(), (List<SortingColumn>)sortedBy));
    }

    @JsonProperty
    public List<String> getBucketedBy() {
        return this.bucketedBy;
    }

    @JsonProperty
    public HiveBucketing.BucketingVersion getBucketingVersion() {
        return this.bucketingVersion;
    }

    @JsonProperty
    public int getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public List<SortingColumn> getSortedBy() {
        return this.sortedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveBucketProperty that = (HiveBucketProperty)o;
        return this.bucketingVersion == that.bucketingVersion && this.bucketCount == that.bucketCount && Objects.equals(this.bucketedBy, that.bucketedBy) && Objects.equals(this.sortedBy, that.sortedBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucketedBy, this.bucketingVersion, this.bucketCount, this.sortedBy});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucketedBy", this.bucketedBy).add("bucketingVersion", (Object)this.bucketingVersion).add("bucketCount", this.bucketCount).add("sortedBy", this.sortedBy).toString();
    }
}

