/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.hive.formats.compression.CompressionKind;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.format.CompressionCodec;

public enum HiveCompressionCodec {
    NONE(null, io.trino.orc.metadata.CompressionKind.NONE, CompressionCodec.UNCOMPRESSED, "null"),
    SNAPPY(CompressionKind.SNAPPY, io.trino.orc.metadata.CompressionKind.SNAPPY, CompressionCodec.SNAPPY, "snappy"),
    LZ4(CompressionKind.LZ4, io.trino.orc.metadata.CompressionKind.LZ4, CompressionCodec.LZ4, null),
    ZSTD(CompressionKind.ZSTD, io.trino.orc.metadata.CompressionKind.ZSTD, CompressionCodec.ZSTD, "zstandard"),
    GZIP(CompressionKind.GZIP, io.trino.orc.metadata.CompressionKind.ZLIB, CompressionCodec.GZIP, "deflate");

    private final Optional<CompressionKind> hiveCompressionKind;
    private final io.trino.orc.metadata.CompressionKind orcCompressionKind;
    private final CompressionCodec parquetCompressionCodec;
    private final Optional<String> avroCompressionCodec;

    private HiveCompressionCodec(CompressionKind hiveCompressionKind, io.trino.orc.metadata.CompressionKind orcCompressionKind, CompressionCodec parquetCompressionCodec, String avroCompressionCodec) {
        this.hiveCompressionKind = Optional.ofNullable(hiveCompressionKind);
        this.orcCompressionKind = Objects.requireNonNull(orcCompressionKind, "orcCompressionKind is null");
        this.parquetCompressionCodec = Objects.requireNonNull(parquetCompressionCodec, "parquetCompressionCodec is null");
        this.avroCompressionCodec = Optional.ofNullable(avroCompressionCodec);
    }

    public Optional<CompressionKind> getHiveCompressionKind() {
        return this.hiveCompressionKind;
    }

    public io.trino.orc.metadata.CompressionKind getOrcCompressionKind() {
        return this.orcCompressionKind;
    }

    public CompressionCodec getParquetCompressionCodec() {
        return this.parquetCompressionCodec;
    }

    public Optional<String> getAvroCompressionCodec() {
        return this.avroCompressionCodec;
    }
}

