/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveBucketValidationRecordCursor;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.hive.coercions.DecimalCoercers;
import io.trino.plugin.hive.coercions.DoubleToFloatCoercer;
import io.trino.plugin.hive.coercions.FloatToDoubleCoercer;
import io.trino.plugin.hive.coercions.IntegerNumberToVarcharCoercer;
import io.trino.plugin.hive.coercions.IntegerNumberUpscaleCoercer;
import io.trino.plugin.hive.coercions.VarcharCoercer;
import io.trino.plugin.hive.coercions.VarcharToIntegerNumberCoercer;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.ListTypeInfo;
import io.trino.plugin.hive.type.MapTypeInfo;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.Path;

public class HivePageSource
implements ConnectorPageSource {
    public static final int ORIGINAL_TRANSACTION_CHANNEL = 0;
    public static final int BUCKET_CHANNEL = 1;
    public static final int ROW_ID_CHANNEL = 2;
    private final List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Optional<BucketAdapter> bucketAdapter;
    private final Optional<BucketValidator> bucketValidator;
    private final Object[] prefilledValues;
    private final Type[] types;
    private final List<Optional<Function<Block, Block>>> coercers;
    private final Optional<ReaderProjectionsAdapter> projectionsAdapter;
    private final ConnectorPageSource delegate;

    public HivePageSource(List<HivePageSourceProvider.ColumnMapping> columnMappings, Optional<HivePageSourceProvider.BucketAdaptation> bucketAdaptation, Optional<BucketValidator> bucketValidator, Optional<ReaderProjectionsAdapter> projectionsAdapter, TypeManager typeManager, ConnectorPageSource delegate) {
        Objects.requireNonNull(columnMappings, "columnMappings is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = columnMappings;
        this.bucketAdapter = bucketAdaptation.map(BucketAdapter::new);
        this.bucketValidator = Objects.requireNonNull(bucketValidator, "bucketValidator is null");
        this.projectionsAdapter = Objects.requireNonNull(projectionsAdapter, "projectionsAdapter is null");
        int size = columnMappings.size();
        this.prefilledValues = new Object[size];
        this.types = new Type[size];
        ImmutableList.Builder coercers = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            Type type;
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            HiveColumnHandle column = columnMapping.getHiveColumnHandle();
            this.types[columnIndex] = type = column.getType();
            if (columnMapping.getKind() != HivePageSourceProvider.ColumnMappingKind.EMPTY && columnMapping.getBaseTypeCoercionFrom().isPresent()) {
                List dereferenceIndices = column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
                HiveType fromType = columnMapping.getBaseTypeCoercionFrom().get().getHiveTypeForDereferences(dereferenceIndices).get();
                HiveType toType = columnMapping.getHiveColumnHandle().getHiveType();
                coercers.add(HivePageSource.createCoercer(typeManager, fromType, toType));
            } else {
                coercers.add(Optional.empty());
            }
            if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.EMPTY || HiveColumnHandle.isRowIdColumnHandle(column)) {
                this.prefilledValues[columnIndex] = null;
                continue;
            }
            if (columnMapping.getKind() != HivePageSourceProvider.ColumnMappingKind.PREFILLED) continue;
            this.prefilledValues[columnIndex] = columnMapping.getPrefilledValue().getValue();
        }
        this.coercers = coercers.build();
    }

    public ConnectorPageSource getDelegate() {
        return this.delegate;
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public OptionalLong getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            if (this.projectionsAdapter.isPresent()) {
                dataPage = this.projectionsAdapter.get().adaptPage(dataPage);
            }
            if (this.bucketAdapter.isPresent() && (dataPage = this.bucketAdapter.get().filterPageToEligibleRowsOrDiscard(dataPage)) == null) {
                return null;
            }
            int batchSize = dataPage.getPositionCount();
            ArrayList<Block> blocks = new ArrayList<Block>();
            block8: for (int fieldId = 0; fieldId < this.columnMappings.size(); ++fieldId) {
                HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(fieldId);
                switch (columnMapping.getKind()) {
                    case PREFILLED: 
                    case EMPTY: {
                        blocks.add(RunLengthEncodedBlock.create((Type)this.types[fieldId], (Object)this.prefilledValues[fieldId], (int)batchSize));
                        continue block8;
                    }
                    case REGULAR: 
                    case SYNTHESIZED: {
                        Block block = dataPage.getBlock(columnMapping.getIndex());
                        Optional<Function<Block, Block>> coercer = this.coercers.get(fieldId);
                        if (coercer.isPresent()) {
                            block = new LazyBlock(batchSize, (LazyBlockLoader)new CoercionLazyBlockLoader(block, coercer.get()));
                        }
                        blocks.add(block);
                        continue block8;
                    }
                    case INTERIM: {
                        continue block8;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            Page page = new Page(batchSize, blocks.toArray(new Block[0]));
            if (this.bucketAdapter.isEmpty()) {
                this.bucketValidator.ifPresent(validator -> validator.validate(page));
            }
            return page;
        }
        catch (TrinoException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw e;
        }
        catch (RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getMemoryUsage() {
        return this.delegate.getMemoryUsage();
    }

    public Metrics getMetrics() {
        return this.delegate.getMetrics();
    }

    public ConnectorPageSource getPageSource() {
        return this.delegate;
    }

    private static Optional<Function<Block, Block>> createCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
        DecimalType toDecimalType;
        DecimalType fromDecimalType;
        VarcharType fromVarcharType;
        if (fromHiveType.equals(toHiveType)) {
            return Optional.empty();
        }
        Type fromType = fromHiveType.getType(typeManager);
        Type toType = toHiveType.getType(typeManager);
        if (toType instanceof VarcharType) {
            VarcharType toVarcharType = (VarcharType)toType;
            if (fromHiveType.equals(HiveType.HIVE_BYTE) || fromHiveType.equals(HiveType.HIVE_SHORT) || fromHiveType.equals(HiveType.HIVE_INT) || fromHiveType.equals(HiveType.HIVE_LONG)) {
                return Optional.of(new IntegerNumberToVarcharCoercer<Type>(fromType, toVarcharType));
            }
        }
        if (fromType instanceof VarcharType) {
            fromVarcharType = (VarcharType)fromType;
            if (toHiveType.equals(HiveType.HIVE_BYTE) || toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG)) {
                return Optional.of(new VarcharToIntegerNumberCoercer<Type>(fromVarcharType, toType));
            }
        }
        if (fromType instanceof VarcharType) {
            fromVarcharType = (VarcharType)fromType;
            if (toType instanceof VarcharType) {
                VarcharType toVarcharType = (VarcharType)toType;
                if (HivePageSource.narrowerThan(toVarcharType, fromVarcharType)) {
                    return Optional.of(new VarcharCoercer(fromVarcharType, toVarcharType));
                }
                return Optional.empty();
            }
        }
        if (fromHiveType.equals(HiveType.HIVE_BYTE) && (toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG))) {
            return Optional.of(new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType));
        }
        if (fromHiveType.equals(HiveType.HIVE_SHORT) && (toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG))) {
            return Optional.of(new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType));
        }
        if (fromHiveType.equals(HiveType.HIVE_INT) && toHiveType.equals(HiveType.HIVE_LONG)) {
            return Optional.of(new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType));
        }
        if (fromHiveType.equals(HiveType.HIVE_FLOAT) && toHiveType.equals(HiveType.HIVE_DOUBLE)) {
            return Optional.of(new FloatToDoubleCoercer());
        }
        if (fromHiveType.equals(HiveType.HIVE_DOUBLE) && toHiveType.equals(HiveType.HIVE_FLOAT)) {
            return Optional.of(new DoubleToFloatCoercer());
        }
        if (fromType instanceof DecimalType) {
            fromDecimalType = (DecimalType)fromType;
            if (toType instanceof DecimalType) {
                DecimalType toDecimalType2 = (DecimalType)toType;
                return Optional.of(DecimalCoercers.createDecimalToDecimalCoercer(fromDecimalType, toDecimalType2));
            }
        }
        if (fromType instanceof DecimalType) {
            fromDecimalType = (DecimalType)fromType;
            if (toType == DoubleType.DOUBLE) {
                return Optional.of(DecimalCoercers.createDecimalToDoubleCoercer(fromDecimalType));
            }
        }
        if (fromType instanceof DecimalType) {
            fromDecimalType = (DecimalType)fromType;
            if (toType == RealType.REAL) {
                return Optional.of(DecimalCoercers.createDecimalToRealCoercer(fromDecimalType));
            }
        }
        if (fromType instanceof DecimalType) {
            fromDecimalType = (DecimalType)fromType;
            if (toType instanceof VarcharType) {
                VarcharType toVarcharType = (VarcharType)toType;
                return Optional.of(DecimalCoercers.createDecimalToVarcharCoercer(fromDecimalType, toVarcharType));
            }
        }
        if (fromType == DoubleType.DOUBLE && toType instanceof DecimalType) {
            toDecimalType = (DecimalType)toType;
            return Optional.of(DecimalCoercers.createDoubleToDecimalCoercer(toDecimalType));
        }
        if (fromType == RealType.REAL && toType instanceof DecimalType) {
            toDecimalType = (DecimalType)toType;
            return Optional.of(DecimalCoercers.createRealToDecimalCoercer(toDecimalType));
        }
        if (fromType instanceof ArrayType && toType instanceof ArrayType) {
            return Optional.of(new ListCoercer(typeManager, fromHiveType, toHiveType));
        }
        if (fromType instanceof MapType && toType instanceof MapType) {
            return Optional.of(new MapCoercer(typeManager, fromHiveType, toHiveType));
        }
        if (fromType instanceof RowType && toType instanceof RowType) {
            HiveType fromHiveTypeStruct = fromHiveType.getCategory() == Category.UNION ? HiveType.toHiveType(fromType) : fromHiveType;
            HiveType toHiveTypeStruct = toHiveType.getCategory() == Category.UNION ? HiveType.toHiveType(toType) : toHiveType;
            return Optional.of(new StructCoercer(typeManager, fromHiveTypeStruct, toHiveTypeStruct));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported coercion from %s to %s", fromHiveType, toHiveType));
    }

    public static boolean narrowerThan(VarcharType first, VarcharType second) {
        Objects.requireNonNull(first, "first is null");
        Objects.requireNonNull(second, "second is null");
        if (first.isUnbounded() || second.isUnbounded()) {
            return !first.isUnbounded();
        }
        return first.getBoundedLength() < second.getBoundedLength();
    }

    public static class BucketAdapter {
        private final int[] bucketColumns;
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int bucketToKeep;
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final List<TypeInfo> typeInfoList;

        public BucketAdapter(HivePageSourceProvider.BucketAdaptation bucketAdaptation) {
            this.bucketColumns = bucketAdaptation.getBucketColumnIndices();
            this.bucketingVersion = bucketAdaptation.getBucketingVersion();
            this.bucketToKeep = bucketAdaptation.getBucketToKeep();
            this.typeInfoList = (List)bucketAdaptation.getBucketColumnHiveTypes().stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
            this.tableBucketCount = bucketAdaptation.getTableBucketCount();
            this.partitionBucketCount = bucketAdaptation.getPartitionBucketCount();
        }

        @Nullable
        public Page filterPageToEligibleRowsOrDiscard(Page page) {
            IntArrayList ids = new IntArrayList(page.getPositionCount());
            Page bucketColumnsPage = page.getColumns(this.bucketColumns);
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int bucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.tableBucketCount, this.typeInfoList, bucketColumnsPage, position);
                if ((bucket - this.bucketToKeep) % this.partitionBucketCount != 0) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("A row that is supposed to be in bucket %s is encountered. Only rows in bucket %s (modulo %s) are expected", bucket, this.bucketToKeep % this.partitionBucketCount, this.partitionBucketCount));
                }
                if (bucket != this.bucketToKeep) continue;
                ids.add(position);
            }
            int retainedRowCount = ids.size();
            if (retainedRowCount == 0) {
                return null;
            }
            if (retainedRowCount == page.getPositionCount()) {
                return page;
            }
            return page.getPositions(ids.elements(), 0, retainedRowCount);
        }
    }

    private static final class CoercionLazyBlockLoader
    implements LazyBlockLoader {
        private final Function<Block, Block> coercer;
        private Block block;

        public CoercionLazyBlockLoader(Block block, Function<Block, Block> coercer) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.coercer = Objects.requireNonNull(coercer, "coercer is null");
        }

        public Block load() {
            Preconditions.checkState((this.block != null ? 1 : 0) != 0, (Object)"Already loaded");
            Block loaded = this.coercer.apply(this.block.getLoadedBlock());
            this.block = null;
            return loaded;
        }
    }

    private static class ListCoercer
    implements Function<Block, Block> {
        private final Optional<Function<Block, Block>> elementCoercer;

        public ListCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManager is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            HiveType fromElementHiveType = HiveType.valueOf(((ListTypeInfo)fromHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            HiveType toElementHiveType = HiveType.valueOf(((ListTypeInfo)toHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            this.elementCoercer = HivePageSource.createCoercer(typeManager, fromElementHiveType, toElementHiveType);
        }

        @Override
        public Block apply(Block block) {
            if (this.elementCoercer.isEmpty()) {
                return block;
            }
            ColumnarArray arrayBlock = ColumnarArray.toColumnarArray((Block)block);
            Block elementsBlock = this.elementCoercer.get().apply(arrayBlock.getElementsBlock());
            boolean[] valueIsNull = new boolean[arrayBlock.getPositionCount()];
            int[] offsets = new int[arrayBlock.getPositionCount() + 1];
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                valueIsNull[i] = arrayBlock.isNull(i);
                offsets[i + 1] = offsets[i] + arrayBlock.getLength(i);
            }
            return ArrayBlock.fromElementBlock((int)arrayBlock.getPositionCount(), Optional.of(valueIsNull), (int[])offsets, (Block)elementsBlock);
        }
    }

    private static class MapCoercer
    implements Function<Block, Block> {
        private final Type toType;
        private final Optional<Function<Block, Block>> keyCoercer;
        private final Optional<Function<Block, Block>> valueCoercer;

        public MapCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManager is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            this.toType = toHiveType.getType(typeManager);
            HiveType fromKeyHiveType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType fromValueHiveType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            HiveType toKeyHiveType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType toValueHiveType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            this.keyCoercer = HivePageSource.createCoercer(typeManager, fromKeyHiveType, toKeyHiveType);
            this.valueCoercer = HivePageSource.createCoercer(typeManager, fromValueHiveType, toValueHiveType);
        }

        @Override
        public Block apply(Block block) {
            ColumnarMap mapBlock = ColumnarMap.toColumnarMap((Block)block);
            Block keysBlock = this.keyCoercer.isEmpty() ? mapBlock.getKeysBlock() : this.keyCoercer.get().apply(mapBlock.getKeysBlock());
            Block valuesBlock = this.valueCoercer.isEmpty() ? mapBlock.getValuesBlock() : this.valueCoercer.get().apply(mapBlock.getValuesBlock());
            boolean[] valueIsNull = new boolean[mapBlock.getPositionCount()];
            int[] offsets = new int[mapBlock.getPositionCount() + 1];
            for (int i = 0; i < mapBlock.getPositionCount(); ++i) {
                valueIsNull[i] = mapBlock.isNull(i);
                offsets[i + 1] = offsets[i] + mapBlock.getEntryCount(i);
            }
            return ((MapType)this.toType).createBlockFromKeyValue(Optional.of(valueIsNull), offsets, keysBlock, valuesBlock);
        }
    }

    private static class StructCoercer
    implements Function<Block, Block> {
        private final List<Optional<Function<Block, Block>>> coercers;
        private final Block[] nullBlocks;

        public StructCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManager is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            List<HiveType> fromFieldTypes = HiveUtil.extractStructFieldTypes(fromHiveType);
            List<HiveType> toFieldTypes = HiveUtil.extractStructFieldTypes(toHiveType);
            ImmutableList.Builder coercers = ImmutableList.builder();
            this.nullBlocks = new Block[toFieldTypes.size()];
            for (int i = 0; i < toFieldTypes.size(); ++i) {
                if (i >= fromFieldTypes.size()) {
                    this.nullBlocks[i] = toFieldTypes.get(i).getType(typeManager).createBlockBuilder(null, 1).appendNull().build();
                    coercers.add(Optional.empty());
                    continue;
                }
                coercers.add(HivePageSource.createCoercer(typeManager, fromFieldTypes.get(i), toFieldTypes.get(i)));
            }
            this.coercers = coercers.build();
        }

        @Override
        public Block apply(Block block) {
            ColumnarRow rowBlock = ColumnarRow.toColumnarRow((Block)block);
            Block[] fields = new Block[this.coercers.size()];
            int[] ids = new int[rowBlock.getField(0).getPositionCount()];
            for (int i = 0; i < this.coercers.size(); ++i) {
                Optional<Function<Block, Block>> coercer = this.coercers.get(i);
                fields[i] = coercer.isPresent() ? coercer.get().apply(rowBlock.getField(i)) : (i < rowBlock.getFieldCount() ? rowBlock.getField(i) : DictionaryBlock.create((int)ids.length, (Block)this.nullBlocks[i], (int[])ids));
            }
            boolean[] valueIsNull = null;
            if (rowBlock.mayHaveNull()) {
                valueIsNull = new boolean[rowBlock.getPositionCount()];
                for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                    valueIsNull[i] = rowBlock.isNull(i);
                }
            }
            return RowBlock.fromFieldBlocks((int)rowBlock.getPositionCount(), Optional.ofNullable(valueIsNull), (Block[])fields);
        }
    }

    public static class BucketValidator {
        public static final int VALIDATION_STRIDE = 97;
        private final Path path;
        private final int[] bucketColumnIndices;
        private final List<TypeInfo> bucketColumnTypes;
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int bucketCount;
        private final int expectedBucket;

        public BucketValidator(Path path, int[] bucketColumnIndices, List<TypeInfo> bucketColumnTypes, HiveBucketing.BucketingVersion bucketingVersion, int bucketCount, int expectedBucket) {
            this.path = Objects.requireNonNull(path, "path is null");
            this.bucketColumnIndices = Objects.requireNonNull(bucketColumnIndices, "bucketColumnIndices is null");
            this.bucketColumnTypes = Objects.requireNonNull(bucketColumnTypes, "bucketColumnTypes is null");
            this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
            this.bucketCount = bucketCount;
            this.expectedBucket = expectedBucket;
            Preconditions.checkArgument((bucketColumnIndices.length == bucketColumnTypes.size() ? 1 : 0) != 0, (Object)"indices and types counts mismatch");
        }

        public void validate(Page page) {
            Page bucketColumnsPage = page.getColumns(this.bucketColumnIndices);
            for (int position = 0; position < page.getPositionCount(); position += 97) {
                int bucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.bucketCount, this.bucketColumnTypes, bucketColumnsPage, position);
                if (bucket == this.expectedBucket) continue;
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table is corrupt. File '%s' is for bucket %s, but contains a row for bucket %s.", this.path, this.expectedBucket, bucket));
            }
        }

        public RecordCursor wrapRecordCursor(RecordCursor delegate, TypeManager typeManager) {
            return new HiveBucketValidationRecordCursor(this.path, this.bucketColumnIndices, (List)this.bucketColumnTypes.stream().map(HiveType::toHiveType).collect(ImmutableList.toImmutableList()), this.bucketingVersion, this.bucketCount, this.expectedBucket, typeManager, delegate);
        }
    }
}

