/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.HivePageSinkMetadata;
import io.trino.spi.connector.SchemaTableName;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveWritableTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<HiveColumnHandle> inputColumns;
    private final HivePageSinkMetadata pageSinkMetadata;
    private final LocationHandle locationHandle;
    private final Optional<HiveBucketProperty> bucketProperty;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final AcidTransaction transaction;
    private final boolean retriesEnabled;

    public HiveWritableTableHandle(String schemaName, String tableName, List<HiveColumnHandle> inputColumns, HivePageSinkMetadata pageSinkMetadata, LocationHandle locationHandle, Optional<HiveBucketProperty> bucketProperty, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, AcidTransaction transaction, boolean retriesEnabled) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.inputColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputColumns, "inputColumns is null"));
        this.pageSinkMetadata = Objects.requireNonNull(pageSinkMetadata, "pageSinkMetadata is null");
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.bucketProperty = Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
        this.retriesEnabled = retriesEnabled;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonIgnore
    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @JsonProperty
    public List<HiveColumnHandle> getInputColumns() {
        return this.inputColumns;
    }

    @JsonProperty
    public HivePageSinkMetadata getPageSinkMetadata() {
        return this.pageSinkMetadata;
    }

    @JsonProperty
    public LocationHandle getLocationHandle() {
        return this.locationHandle;
    }

    @JsonProperty
    public Optional<HiveBucketProperty> getBucketProperty() {
        return this.bucketProperty;
    }

    @JsonProperty
    public HiveStorageFormat getTableStorageFormat() {
        return this.tableStorageFormat;
    }

    @JsonProperty
    public HiveStorageFormat getPartitionStorageFormat() {
        return this.partitionStorageFormat;
    }

    @JsonProperty
    public AcidTransaction getTransaction() {
        return this.transaction;
    }

    @JsonIgnore
    public boolean isTransactional() {
        return this.transaction.isTransactional();
    }

    @JsonProperty
    public boolean isRetriesEnabled() {
        return this.retriesEnabled;
    }

    public String toString() {
        return this.schemaName + "." + this.tableName;
    }
}

