/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.filesystem.TrinoInputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.NameBasedFieldMapper;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcPredicate;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcRecordReader;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.orc.HdfsOrcDataSource;
import io.trino.plugin.hive.orc.OrcPageSource;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.joda.time.DateTimeZone;

public class OrcDeleteDeltaPageSource
implements ConnectorPageSource {
    private final OrcRecordReader recordReader;
    private final OrcDataSource orcDataSource;
    private final FileFormatDataSourceStats stats;
    private final AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
    private boolean closed;

    public static Optional<ConnectorPageSource> createOrcDeleteDeltaPageSource(TrinoInputFile inputFile, OrcReaderOptions options, FileFormatDataSourceStats stats) {
        HdfsOrcDataSource orcDataSource;
        String path = inputFile.location();
        try {
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(inputFile.location()), inputFile.length(), options, inputFile, stats);
        }
        catch (Exception e) {
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, OrcDeleteDeltaPageSource.openError(e, path), (Throwable)e);
        }
        try {
            Optional orcReader = OrcReader.createOrcReader((OrcDataSource)orcDataSource, (OrcReaderOptions)options);
            if (orcReader.isPresent()) {
                return Optional.of(new OrcDeleteDeltaPageSource(path, inputFile.length(), (OrcReader)orcReader.get(), (OrcDataSource)orcDataSource, stats));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            try {
                orcDataSource.close();
            }
            catch (IOException ex) {
                e.addSuppressed(ex);
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)((Object)e);
            }
            String message = OrcDeleteDeltaPageSource.openError(e, path);
            if (e instanceof BlockMissingException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private OrcDeleteDeltaPageSource(String path, long fileSize, OrcReader reader, OrcDataSource orcDataSource, FileFormatDataSourceStats stats) throws OrcCorruptionException {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        OrcPageSourceFactory.verifyAcidSchema(reader, new Path(path));
        ImmutableMap acidColumns = Maps.uniqueIndex((Iterable)reader.getRootColumn().getNestedColumns(), orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
        ImmutableList rowIdColumns = ImmutableList.of((Object)((OrcColumn)acidColumns.get("originalTransaction".toLowerCase(Locale.ENGLISH))), (Object)((OrcColumn)acidColumns.get("bucket".toLowerCase(Locale.ENGLISH))), (Object)((OrcColumn)acidColumns.get("rowId".toLowerCase(Locale.ENGLISH))));
        this.recordReader = reader.createRecordReader((List)rowIdColumns, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)OrcReader.fullyProjectedLayout(), (Object)OrcReader.fullyProjectedLayout(), (Object)OrcReader.fullyProjectedLayout()), OrcPredicate.TRUE, 0L, fileSize, DateTimeZone.UTC, this.memoryContext, 8196, exception -> OrcPageSource.handleException(orcDataSource.getId(), exception), NameBasedFieldMapper::create);
    }

    public long getCompletedBytes() {
        return this.orcDataSource.getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            Page page = this.recordReader.nextPage();
            if (page == null) {
                this.close();
            }
            return page;
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw OrcPageSource.handleException(this.orcDataSource.getId(), e);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.stats.addMaxCombinedBytesPerRow(this.recordReader.getMaxCombinedBytesPerRow());
            this.recordReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orcDataSource", (Object)this.orcDataSource.getId()).toString();
    }

    public long getMemoryUsage() {
        return this.memoryContext.getBytes();
    }

    private static String openError(Throwable t, String path) {
        return String.format("Error opening Hive delete delta file %s: %s", path, t.getMessage());
    }
}

