/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.type;

import com.google.common.base.Preconditions;
import io.trino.plugin.hive.type.BaseCharTypeInfo;
import io.trino.plugin.hive.type.CharTypeInfo;
import io.trino.plugin.hive.type.DecimalTypeInfo;
import io.trino.plugin.hive.type.ListTypeInfo;
import io.trino.plugin.hive.type.MapTypeInfo;
import io.trino.plugin.hive.type.PrimitiveCategory;
import io.trino.plugin.hive.type.PrimitiveTypeInfo;
import io.trino.plugin.hive.type.StructTypeInfo;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.type.TypeInfoUtils;
import io.trino.plugin.hive.type.UnionTypeInfo;
import io.trino.plugin.hive.type.VarcharTypeInfo;
import java.util.List;

public final class TypeInfoFactory {
    private TypeInfoFactory() {
    }

    public static PrimitiveTypeInfo getPrimitiveTypeInfo(String typeName) {
        String baseName = TypeInfoUtils.getBaseName(typeName);
        TypeInfoUtils.PrimitiveTypeEntry typeEntry = TypeInfoUtils.getTypeEntryFromTypeName(baseName);
        Preconditions.checkArgument((typeEntry != null ? 1 : 0) != 0, (String)"Unknown type: %s", (Object)typeName);
        return switch (typeEntry.primitiveCategory()) {
            case PrimitiveCategory.CHAR -> {
                TypeInfoUtils.PrimitiveParts parts = TypeInfoUtils.parsePrimitiveParts(typeName);
                Preconditions.checkArgument((parts.typeParams().length == 1 ? 1 : 0) != 0);
                yield new CharTypeInfo(Integer.parseInt(parts.typeParams()[0]));
            }
            case PrimitiveCategory.VARCHAR -> {
                TypeInfoUtils.PrimitiveParts parts = TypeInfoUtils.parsePrimitiveParts(typeName);
                Preconditions.checkArgument((parts.typeParams().length == 1 ? 1 : 0) != 0);
                yield new VarcharTypeInfo(Integer.parseInt(parts.typeParams()[0]));
            }
            case PrimitiveCategory.DECIMAL -> {
                TypeInfoUtils.PrimitiveParts parts = TypeInfoUtils.parsePrimitiveParts(typeName);
                Preconditions.checkArgument((parts.typeParams().length == 2 ? 1 : 0) != 0);
                yield new DecimalTypeInfo(Integer.parseInt(parts.typeParams()[0]), Integer.parseInt(parts.typeParams()[1]));
            }
            default -> new PrimitiveTypeInfo(typeName);
        };
    }

    public static CharTypeInfo getCharTypeInfo(int length) {
        return (CharTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo(BaseCharTypeInfo.charTypeName("char", length));
    }

    public static VarcharTypeInfo getVarcharTypeInfo(int length) {
        return (VarcharTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo(BaseCharTypeInfo.charTypeName("varchar", length));
    }

    public static DecimalTypeInfo getDecimalTypeInfo(int precision, int scale) {
        return (DecimalTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo(DecimalTypeInfo.decimalTypeName(precision, scale));
    }

    public static TypeInfo getStructTypeInfo(List<String> names, List<TypeInfo> typeInfos) {
        return new StructTypeInfo(names, typeInfos);
    }

    public static TypeInfo getUnionTypeInfo(List<TypeInfo> typeInfos) {
        return new UnionTypeInfo(typeInfos);
    }

    public static TypeInfo getListTypeInfo(TypeInfo elementTypeInfo) {
        return new ListTypeInfo(elementTypeInfo);
    }

    public static TypeInfo getMapTypeInfo(TypeInfo keyTypeInfo, TypeInfo valueTypeInfo) {
        return new MapTypeInfo(keyTypeInfo, valueTypeInfo);
    }
}

