/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.type;

import com.google.common.base.Preconditions;
import io.trino.plugin.hive.type.BaseCharTypeInfo;

public final class VarcharTypeInfo
extends BaseCharTypeInfo {
    public static final int MAX_VARCHAR_LENGTH = 65535;

    public VarcharTypeInfo(int length) {
        super("varchar", length);
        Preconditions.checkArgument((length >= 1 && length <= 65535 ? 1 : 0) != 0, (String)"invalid varchar length: %s", (int)length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof VarcharTypeInfo)) return false;
        VarcharTypeInfo o = (VarcharTypeInfo)other;
        if (this.getLength() != o.getLength()) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.getLength();
    }
}

