/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.plugin.hive.RecordFileWriter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class SequenceFileRecordWriter
implements RecordFileWriter.ExtendedRecordWriter {
    private long finalWrittenBytes = -1L;
    private final SequenceFile.Writer writer;
    private static final Writable EMPTY_KEY = new BytesWritable();

    public SequenceFileRecordWriter(Path path, JobConf jobConf, Class<?> valueClass, boolean compressed) throws IOException {
        this.writer = Utilities.createSequenceWriter((JobConf)jobConf, (FileSystem)path.getFileSystem((Configuration)jobConf), (Path)path, BytesWritable.class, valueClass, (boolean)compressed, (Progressable)Reporter.NULL);
    }

    @Override
    public long getWrittenBytes() {
        if (this.finalWrittenBytes != -1L) {
            return this.finalWrittenBytes;
        }
        try {
            return this.writer.getLength();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void write(Writable writable) throws IOException {
        this.writer.append(EMPTY_KEY, writable);
    }

    public void close(boolean abort) throws IOException {
        try (SequenceFile.Writer ignored = this.writer;){
            if (this.finalWrittenBytes == -1L) {
                this.writer.hflush();
                this.finalWrittenBytes = this.writer.getLength();
            }
        }
    }
}

