/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreDecorator;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.cache.ImpersonationCachingConfig;
import io.trino.plugin.hive.metastore.cache.SharedHiveMetastoreCache;
import io.trino.plugin.hive.metastore.procedure.FlushHiveMetastoreCacheProcedure;
import io.trino.plugin.hive.metastore.recording.RecordingHiveMetastoreDecoratorModule;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.guice.ExportBinder;

public class DecoratedHiveMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        Multibinder.newSetBinder((Binder)binder, HiveMetastoreDecorator.class);
        this.install((Module)new RecordingHiveMetastoreDecoratorModule());
        ConfigBinder.configBinder((Binder)binder).bindConfig(CachingHiveMetastoreConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ImpersonationCachingConfig.class);
        binder.bind(SharedHiveMetastoreCache.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(HiveMetastoreFactory.class).as(generator -> generator.generatedNameOf(CachingHiveMetastore.class));
        Multibinder.newSetBinder((Binder)binder, Procedure.class).addBinding().toProvider(FlushHiveMetastoreCacheProcedure.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public static HiveMetastoreFactory createHiveMetastore(@RawHiveMetastoreFactory HiveMetastoreFactory metastoreFactory, Set<HiveMetastoreDecorator> decorators, SharedHiveMetastoreCache sharedHiveMetastoreCache) {
        metastoreFactory = new DecoratingHiveMetastoreFactory(metastoreFactory, decorators);
        return sharedHiveMetastoreCache.createCachingHiveMetastoreFactory(metastoreFactory);
    }

    @Provides
    @Singleton
    public static Optional<CachingHiveMetastore> createHiveMetastore(HiveMetastoreFactory metastoreFactory) {
        if (metastoreFactory instanceof SharedHiveMetastoreCache.CachingHiveMetastoreFactory) {
            return Optional.of(((SharedHiveMetastoreCache.CachingHiveMetastoreFactory)metastoreFactory).getMetastore());
        }
        return Optional.empty();
    }

    private static class DecoratingHiveMetastoreFactory
    implements HiveMetastoreFactory {
        private final HiveMetastoreFactory delegate;
        private final List<HiveMetastoreDecorator> sortedDecorators;

        public DecoratingHiveMetastoreFactory(HiveMetastoreFactory delegate, Set<HiveMetastoreDecorator> decorators) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.sortedDecorators = (List)decorators.stream().sorted(Comparator.comparing(HiveMetastoreDecorator::getPriority)).collect(ImmutableList.toImmutableList());
        }

        @Override
        public boolean isImpersonationEnabled() {
            return this.delegate.isImpersonationEnabled();
        }

        @Override
        public HiveMetastore createMetastore(Optional<ConnectorIdentity> identity) {
            HiveMetastore metastore = this.delegate.createMetastore(identity);
            for (HiveMetastoreDecorator decorator : this.sortedDecorators) {
                metastore = decorator.decorate(metastore);
            }
            return metastore;
        }
    }
}

