/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveRecordCursorProvider;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.s3select.IonSqlQueryBuilder;
import io.trino.plugin.hive.s3select.S3SelectDataType;
import io.trino.plugin.hive.s3select.S3SelectLineRecordReader;
import io.trino.plugin.hive.s3select.S3SelectLineRecordReaderProvider;
import io.trino.plugin.hive.s3select.S3SelectRecordCursor;
import io.trino.plugin.hive.s3select.S3SelectSerDeDataTypeMapper;
import io.trino.plugin.hive.s3select.TrinoS3ClientFactory;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.type.TypeInfoUtils;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class S3SelectRecordCursorProvider
implements HiveRecordCursorProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final TrinoS3ClientFactory s3ClientFactory;

    @Inject
    public S3SelectRecordCursorProvider(HdfsEnvironment hdfsEnvironment, TrinoS3ClientFactory s3ClientFactory) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.s3ClientFactory = Objects.requireNonNull(s3ClientFactory, "s3ClientFactory is null");
    }

    @Override
    public Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> createRecordCursor(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, TypeManager typeManager, boolean s3SelectPushdownEnabled) {
        if (!s3SelectPushdownEnabled) {
            return Optional.empty();
        }
        try {
            this.hdfsEnvironment.getFileSystem(session.getIdentity(), path, configuration);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + path, (Throwable)e);
        }
        Optional<ReaderColumns> projectedReaderColumns = HivePageSourceProvider.projectBaseColumns(columns);
        effectivePredicate = effectivePredicate.filter((column, domain) -> column.isBaseColumn());
        List readerColumns = (List)projectedReaderColumns.map(readColumns -> (ImmutableList)readColumns.get().stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).orElseGet(() -> ImmutableList.copyOf((Collection)columns));
        if (!S3SelectRecordCursorProvider.hasFilters(schema, (TupleDomain<HiveColumnHandle>)effectivePredicate, readerColumns)) {
            return Optional.empty();
        }
        String serdeName = HiveUtil.getDeserializerClassName(schema);
        Optional<S3SelectDataType> s3SelectDataTypeOptional = S3SelectSerDeDataTypeMapper.getDataType(serdeName);
        if (s3SelectDataTypeOptional.isPresent()) {
            S3SelectDataType s3SelectDataType = s3SelectDataTypeOptional.get();
            IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(typeManager, s3SelectDataType);
            String ionSqlQuery = queryBuilder.buildSql(readerColumns, (TupleDomain<HiveColumnHandle>)effectivePredicate);
            Optional<S3SelectLineRecordReader> recordReader = S3SelectLineRecordReaderProvider.get(configuration, path, start, length, schema, ionSqlQuery, this.s3ClientFactory, s3SelectDataType);
            if (recordReader.isEmpty()) {
                return Optional.empty();
            }
            S3SelectRecordCursor cursor = new S3SelectRecordCursor(configuration, path, recordReader.get(), length, schema, readerColumns);
            return Optional.of(new HiveRecordCursorProvider.ReaderRecordCursorWithProjections(cursor, projectedReaderColumns));
        }
        return Optional.empty();
    }

    private static boolean hasFilters(Properties schema, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> readerColumns) {
        if (effectivePredicate.isAll()) {
            return !S3SelectRecordCursorProvider.isEquivalentSchema(readerColumns, schema);
        }
        return true;
    }

    private static boolean isEquivalentSchema(List<HiveColumnHandle> readerColumns, Properties schema) {
        Set<String> projectedColumnNames = S3SelectRecordCursorProvider.getColumnProperty(readerColumns, HiveColumnHandle::getName);
        Set<String> projectedColumnTypes = S3SelectRecordCursorProvider.getColumnProperty(readerColumns, column -> column.getHiveType().getTypeInfo().getTypeName());
        return S3SelectRecordCursorProvider.isEquivalentColumns(projectedColumnNames, schema) && S3SelectRecordCursorProvider.isEquivalentColumnTypes(projectedColumnTypes, schema);
    }

    private static boolean isEquivalentColumns(Set<String> projectedColumnNames, Properties schema) {
        Object columnNames;
        String columnNameProperty = schema.getProperty("columns");
        if (columnNameProperty.length() == 0) {
            columnNames = ImmutableSet.of();
        } else {
            String columnNameDelimiter = (String)schema.getOrDefault((Object)"column.name.delimiter", ",");
            columnNames = (Set)Arrays.stream(columnNameProperty.split(columnNameDelimiter)).collect(ImmutableSet.toImmutableSet());
        }
        return projectedColumnNames.equals(columnNames);
    }

    private static boolean isEquivalentColumnTypes(Set<String> projectedColumnTypes, Properties schema) {
        String columnTypeProperty = schema.getProperty("columns.types");
        Object columnTypes = columnTypeProperty.length() == 0 ? ImmutableSet.of() : (Set)TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty).stream().map(TypeInfo::getTypeName).collect(ImmutableSet.toImmutableSet());
        return projectedColumnTypes.equals(columnTypes);
    }

    private static Set<String> getColumnProperty(List<HiveColumnHandle> readerColumns, Function<HiveColumnHandle, String> mapper) {
        if (readerColumns.isEmpty()) {
            return ImmutableSet.of();
        }
        return (Set)readerColumns.stream().map(mapper).collect(ImmutableSet.toImmutableSet());
    }
}

