/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class StepBoolean {
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private static final AtomicIntegerFieldUpdater<StepBoolean> STATE_FIELD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(StepBoolean.class, "state");
    private final int initialState;
    private volatile int state;

    StepBoolean(boolean initialState) {
        this.state = this.initialState = initialState ? 1 : 0;
    }

    boolean get() {
        return this.state == 1;
    }

    boolean change() {
        int notInitialState = this.initialState == 1 ? 0 : 1;
        return STATE_FIELD_UPDATER.compareAndSet(this, this.initialState, notInitialState);
    }

    boolean hasChanged() {
        return this.state != this.initialState;
    }
}

