/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class OrcType {
    private final OrcTypeKind orcTypeKind;
    private final List<OrcColumnId> fieldTypeIndexes;
    private final List<String> fieldNames;
    private final Optional<Integer> length;
    private final Optional<Integer> precision;
    private final Optional<Integer> scale;
    private final Map<String, String> attributes;

    private OrcType(OrcTypeKind orcTypeKind) {
        this(orcTypeKind, (List<OrcColumnId>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, String>)ImmutableMap.of());
    }

    private OrcType(OrcTypeKind orcTypeKind, int length) {
        this(orcTypeKind, (List<OrcColumnId>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.of(length), Optional.empty(), Optional.empty(), (Map<String, String>)ImmutableMap.of());
    }

    private OrcType(OrcTypeKind orcTypeKind, int precision, int scale) {
        this(orcTypeKind, (List<OrcColumnId>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), Optional.of(precision), Optional.of(scale), (Map<String, String>)ImmutableMap.of());
    }

    private OrcType(OrcTypeKind orcTypeKind, List<OrcColumnId> fieldTypeIndexes, List<String> fieldNames) {
        this(orcTypeKind, fieldTypeIndexes, fieldNames, Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, String>)ImmutableMap.of());
    }

    public OrcType(OrcTypeKind orcTypeKind, List<OrcColumnId> fieldTypeIndexes, List<String> fieldNames, Optional<Integer> length, Optional<Integer> precision, Optional<Integer> scale, Map<String, String> attributes) {
        this.orcTypeKind = Objects.requireNonNull(orcTypeKind, "orcTypeKind is null");
        this.fieldTypeIndexes = ImmutableList.copyOf((Collection)Objects.requireNonNull(fieldTypeIndexes, "fieldTypeIndexes is null"));
        if (fieldNames == null || fieldNames.isEmpty() && !fieldTypeIndexes.isEmpty()) {
            this.fieldNames = null;
        } else {
            this.fieldNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(fieldNames, "fieldNames is null"));
            Preconditions.checkArgument((fieldNames.size() == fieldTypeIndexes.size() ? 1 : 0) != 0, (Object)"fieldNames and fieldTypeIndexes have different sizes");
        }
        this.length = Objects.requireNonNull(length, "length is null");
        this.precision = Objects.requireNonNull(precision, "precision is null");
        this.scale = Objects.requireNonNull(scale, "scale cannot be null");
        this.attributes = ImmutableMap.copyOf(Objects.requireNonNull(attributes, "attributes is null"));
    }

    public OrcTypeKind getOrcTypeKind() {
        return this.orcTypeKind;
    }

    public int getFieldCount() {
        return this.fieldTypeIndexes.size();
    }

    public OrcColumnId getFieldTypeIndex(int field) {
        return this.fieldTypeIndexes.get(field);
    }

    public List<OrcColumnId> getFieldTypeIndexes() {
        return this.fieldTypeIndexes;
    }

    public String getFieldName(int field) {
        return this.fieldNames.get(field);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public Optional<Integer> getLength() {
        return this.length;
    }

    public Optional<Integer> getPrecision() {
        return this.precision;
    }

    public Optional<Integer> getScale() {
        return this.scale;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orcTypeKind", (Object)this.orcTypeKind).add("fieldTypeIndexes", this.fieldTypeIndexes).add("fieldNames", this.fieldNames).toString();
    }

    private static List<OrcType> toOrcType(int nextFieldTypeIndex, Type type, Optional<Function<Type, Optional<OrcType>>> additionalTypeMapping) {
        Optional<List> orcType = additionalTypeMapping.flatMap(mapping -> (Optional)mapping.apply(type)).map(ImmutableList::of);
        if (orcType.isPresent()) {
            return orcType.get();
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.BOOLEAN));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.BYTE));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.SHORT));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.INT));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.LONG));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.DOUBLE));
        }
        if (RealType.REAL.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.FLOAT));
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return ImmutableList.of((Object)new OrcType(OrcTypeKind.STRING));
            }
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.VARCHAR, varcharType.getBoundedLength()));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.CHAR, charType.getLength()));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.BINARY));
        }
        if (DateType.DATE.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.DATE));
        }
        if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type) || TimestampType.TIMESTAMP_MICROS.equals((Object)type) || TimestampType.TIMESTAMP_NANOS.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.TIMESTAMP));
        }
        if (TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.equals((Object)type) || TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.equals((Object)type) || TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS.equals((Object)type)) {
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.TIMESTAMP_INSTANT));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return ImmutableList.of((Object)new OrcType(OrcTypeKind.DECIMAL, decimalType.getPrecision(), decimalType.getScale()));
        }
        if (type instanceof ArrayType) {
            return OrcType.createOrcArrayType(nextFieldTypeIndex, (Type)type.getTypeParameters().get(0), additionalTypeMapping);
        }
        if (type instanceof MapType) {
            return OrcType.createOrcMapType(nextFieldTypeIndex, (Type)type.getTypeParameters().get(0), (Type)type.getTypeParameters().get(1), additionalTypeMapping);
        }
        if (type instanceof RowType) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (int i = 0; i < type.getTypeSignature().getParameters().size(); ++i) {
                TypeSignatureParameter parameter = (TypeSignatureParameter)type.getTypeSignature().getParameters().get(i);
                fieldNames.add((String)((Object)parameter.getNamedTypeSignature().getName().orElse("field" + i)));
            }
            List fieldTypes = type.getTypeParameters();
            return OrcType.createOrcRowType(nextFieldTypeIndex, fieldNames, fieldTypes, additionalTypeMapping);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", type));
    }

    private static List<OrcType> createOrcArrayType(int nextFieldTypeIndex, Type itemType, Optional<Function<Type, Optional<OrcType>>> additionalTypeMapping) {
        List<OrcType> itemTypes = OrcType.toOrcType(++nextFieldTypeIndex, itemType, additionalTypeMapping);
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcTypeKind.LIST, (List<OrcColumnId>)ImmutableList.of((Object)new OrcColumnId(nextFieldTypeIndex)), (List<String>)ImmutableList.of((Object)"item")));
        orcTypes.addAll(itemTypes);
        return orcTypes;
    }

    private static List<OrcType> createOrcMapType(int nextFieldTypeIndex, Type keyType, Type valueType, Optional<Function<Type, Optional<OrcType>>> additionalTypeMapping) {
        List<OrcType> keyTypes = OrcType.toOrcType(++nextFieldTypeIndex, keyType, additionalTypeMapping);
        List<OrcType> valueTypes = OrcType.toOrcType(nextFieldTypeIndex + keyTypes.size(), valueType, additionalTypeMapping);
        ArrayList<OrcType> orcTypes = new ArrayList<OrcType>();
        orcTypes.add(new OrcType(OrcTypeKind.MAP, (List<OrcColumnId>)ImmutableList.of((Object)new OrcColumnId(nextFieldTypeIndex), (Object)new OrcColumnId(nextFieldTypeIndex + keyTypes.size())), (List<String>)ImmutableList.of((Object)"key", (Object)"value")));
        orcTypes.addAll(keyTypes);
        orcTypes.addAll(valueTypes);
        return orcTypes;
    }

    public static ColumnMetadata<OrcType> createRootOrcType(List<String> fieldNames, List<Type> fieldTypes) {
        return OrcType.createRootOrcType(fieldNames, fieldTypes, Optional.empty());
    }

    @VisibleForTesting
    public static ColumnMetadata<OrcType> createRootOrcType(List<String> fieldNames, List<Type> fieldTypes, Optional<Function<Type, Optional<OrcType>>> additionalTypeMapping) {
        return new ColumnMetadata<OrcType>(OrcType.createOrcRowType(0, fieldNames, fieldTypes, additionalTypeMapping));
    }

    private static List<OrcType> createOrcRowType(int nextFieldTypeIndex, List<String> fieldNames, List<Type> fieldTypes, Optional<Function<Type, Optional<OrcType>>> additionalTypeMapping) {
        ++nextFieldTypeIndex;
        ArrayList<OrcColumnId> fieldTypeIndexes = new ArrayList<OrcColumnId>();
        ArrayList<List<OrcType>> fieldTypesList = new ArrayList<List<OrcType>>();
        for (Type fieldType : fieldTypes) {
            fieldTypeIndexes.add(new OrcColumnId(nextFieldTypeIndex));
            List<OrcType> fieldOrcTypes = OrcType.toOrcType(nextFieldTypeIndex, fieldType, additionalTypeMapping);
            fieldTypesList.add(fieldOrcTypes);
            nextFieldTypeIndex += fieldOrcTypes.size();
        }
        ImmutableList.Builder orcTypes = ImmutableList.builder();
        orcTypes.add((Object)new OrcType(OrcTypeKind.STRUCT, fieldTypeIndexes, fieldNames));
        fieldTypesList.forEach(arg_0 -> ((ImmutableList.Builder)orcTypes).addAll(arg_0));
        return orcTypes.build();
    }

    public static enum OrcTypeKind {
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        DECIMAL,
        FLOAT,
        DOUBLE,
        STRING,
        VARCHAR,
        CHAR,
        BINARY,
        DATE,
        TIMESTAMP,
        TIMESTAMP_INSTANT,
        LIST,
        MAP,
        STRUCT,
        UNION;

    }
}

