/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.log.MessageOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.weakref.jmx.Managed;

class BufferedHandler
extends Handler {
    private static final int MAX_BATCH_COUNT = 1024;
    private static final byte[] POISON_MESSAGE = new byte[0];
    private final MessageOutput messageOutput;
    private final Thread thread;
    private final BlockingQueue<byte[]> queue = new ArrayBlockingQueue<byte[]>(1024);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicLong droppedMessages = new AtomicLong(0L);

    public BufferedHandler(MessageOutput messageOutput, Formatter formatter, ErrorManager errorManager) {
        this.messageOutput = Objects.requireNonNull(messageOutput, "messageOutput is null");
        this.setErrorManager(Objects.requireNonNull(errorManager, "errorManager is null"));
        this.setFormatter(Objects.requireNonNull(formatter, "formatter is null"));
        this.thread = new Thread(this::logging);
        this.thread.setName("log-writer");
        this.thread.setDaemon(true);
    }

    @Override
    public void publish(LogRecord record) {
        byte[] message;
        if (this.closed.get()) {
            this.droppedMessages.getAndIncrement();
            return;
        }
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            message = this.getFormatter().format(record).getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.reportError(null, e, 5);
            return;
        }
        try {
            BufferedHandler.putUninterruptibly(this.queue, message);
        }
        catch (Exception e) {
            this.reportError(null, e, 1);
        }
        if (this.closed.get()) {
            this.queue.remove(message);
        }
    }

    @Override
    public synchronized void flush() {
        try {
            this.messageOutput.flush();
        }
        catch (Exception e) {
            this.reportError(null, e, 2);
        }
    }

    @Override
    public void close() {
        this.closed.set(true);
        BufferedHandler.putUninterruptibly(this.queue, POISON_MESSAGE);
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.queue.clear();
    }

    @VisibleForTesting
    MessageOutput getMessageOutput() {
        return this.messageOutput;
    }

    protected void start() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logging() {
        this.processQueue();
        MessageOutput messageOutput = this.messageOutput;
        synchronized (messageOutput) {
            try {
                this.messageOutput.close();
            }
            catch (IOException e) {
                this.reportError("Could not close the MessageOutput", e, 3);
            }
        }
        this.queue.clear();
    }

    private void processQueue() {
        List<Object> batch = new ArrayList<byte[]>(1024);
        boolean poisonMessageSeen = false;
        while (!poisonMessageSeen) {
            if (this.queue.isEmpty()) {
                try {
                    batch.add(this.queue.take());
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.queue.drainTo(batch, 1024);
            }
            int poisonMessageIndex = BufferedHandler.getPoisonMessageIndex(batch);
            if (poisonMessageIndex >= 0) {
                poisonMessageSeen = true;
                batch = batch.subList(0, poisonMessageIndex);
            }
            this.logMessageBatch(batch);
            batch.clear();
        }
    }

    private synchronized void logMessageBatch(List<byte[]> batch) {
        for (byte[] message : batch) {
            try {
                this.messageOutput.writeMessage(message);
            }
            catch (Exception e) {
                this.reportError(null, e, 1);
            }
        }
        this.flush();
    }

    private static <T> void putUninterruptibly(BlockingQueue<T> queue, T element) {
        boolean interrupted = false;
        while (true) {
            try {
                queue.put(element);
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static int getPoisonMessageIndex(List<byte[]> messages) {
        for (int i = 0; i < messages.size(); ++i) {
            if (messages.get(i) != POISON_MESSAGE) continue;
            return i;
        }
        return -1;
    }

    @Managed
    public long getDroppedMessages() {
        return this.droppedMessages.get();
    }
}

