/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.base.Throwables;
import com.google.shaded.shaded.common.collect.ImmutableCollection;
import com.google.shaded.shaded.common.collect.ImmutableList;
import com.google.shaded.shaded.common.util.concurrent.ListenableFuture;
import com.google.shaded.shaded.common.util.concurrent.ListeningExecutorService;
import com.google.shaded.shaded.common.util.concurrent.MoreExecutors;
import com.qubole.rubix.common.metrics.CachingFileSystemMetrics;
import com.qubole.rubix.common.metrics.CustomMetricsReporterProvider;
import com.qubole.rubix.core.CachedReadRequestChain;
import com.qubole.rubix.core.CachingFileSystemStatsProvider;
import com.qubole.rubix.core.ChainedReadRequestChain;
import com.qubole.rubix.core.DirectReadRequestChain;
import com.qubole.rubix.core.NonLocalReadRequestChain;
import com.qubole.rubix.core.NonLocalRequestChain;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.core.RemoteFetchRequestChain;
import com.qubole.rubix.core.RemoteReadRequestChain;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.ClusterType;
import com.qubole.rubix.spi.RetryingPooledBookkeeperClient;
import com.qubole.rubix.spi.thrift.BlockLocation;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.CacheStatusResponse;
import com.qubole.rubix.spi.thrift.FileInfo;
import com.qubole.rubix.spi.thrift.Location;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.DirectBufferPool;

public class CachingInputStream
extends FSInputStream {
    private FSDataInputStream inputStream;
    private long nextReadPosition;
    private long nextReadBlock;
    int blockSize;
    private CachingFileSystemStatsProvider stats;
    static ListeningExecutorService readService = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(100, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setName("rubix-readRequest-thread");
            t.setDaemon(true);
            return t;
        }
    }));
    private static final Log log = LogFactory.getLog(CachingInputStream.class);
    protected final String remotePath;
    private long fileSize;
    private long lastModified;
    Configuration conf;
    private boolean strictMode;
    ClusterType clusterType;
    FileSystem remoteFileSystem;
    FileSystem.Statistics statistics;
    private static DirectBufferPool bufferPool = new DirectBufferPool();
    private byte[] affixBuffer;
    private int diskReadBufferSize;
    private final int bufferSize;
    BookKeeperFactory bookKeeperFactory;

    public CachingInputStream(Path backendPath, Configuration conf, CachingFileSystemStatsProvider stats, ClusterType clusterType, BookKeeperFactory bookKeeperFactory, FileSystem remoteFileSystem, int bufferSize, FileSystem.Statistics statistics) throws IOException {
        this.conf = conf;
        this.strictMode = CacheConfig.isStrictMode(conf);
        this.remotePath = backendPath.toString();
        this.blockSize = CacheConfig.getBlockSize(conf);
        this.diskReadBufferSize = CacheConfig.getDiskReadBufferSize(conf);
        this.bookKeeperFactory = bookKeeperFactory;
        this.remoteFileSystem = remoteFileSystem;
        this.fileSize = -1L;
        if (!CacheConfig.isFileStalenessCheckEnabled(conf)) {
            try (RetryingPooledBookkeeperClient bookKeeperClient = bookKeeperFactory.createBookKeeperClient(conf);){
                FileInfo fileInfo = bookKeeperClient.getFileInfo(backendPath.toString());
                this.fileSize = fileInfo.fileSize;
                this.lastModified = fileInfo.lastModified;
            }
            catch (Exception ex) {
                if (this.strictMode) {
                    throw new RuntimeException(ex);
                }
                log.error((Object)String.format("Could not get FileInfo for %s. Fetching FileStatus from remote file system :", backendPath.toString()), (Throwable)ex);
            }
        }
        if (this.fileSize == -1L) {
            FileStatus fileStatus = remoteFileSystem.getFileStatus(backendPath);
            this.fileSize = fileStatus.getLen();
            this.lastModified = fileStatus.getModificationTime();
        }
        this.stats = stats;
        this.clusterType = clusterType;
        this.bufferSize = bufferSize;
        this.statistics = statistics;
    }

    FSDataInputStream getParentDataInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.remoteFileSystem.open(new Path(this.remotePath), this.bufferSize);
        }
        return this.inputStream;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        this.nextReadPosition = pos;
        this.setNextReadBlock();
    }

    public long getPos() throws IOException {
        return this.nextReadPosition;
    }

    public boolean seekToNewSource(long l) throws IOException {
        return false;
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        try {
            return this.readInternal(buffer, offset, length);
        }
        catch (InterruptedException e) {
            throw Throwables.propagate(e);
        }
        catch (Exception e) {
            log.error((Object)String.format("Failed to read from rubix for file %s position %d length %d. Falling back to remote", this.remotePath, this.nextReadPosition, length), (Throwable)e);
            CustomMetricsReporterProvider.getCustomMetricsReporter().addMetric(CachingFileSystemMetrics.POSITIONAL_READ_FAILURE);
            this.getParentDataInputStream().seek(this.nextReadPosition);
            int read = this.readFullyDirect(buffer, offset, length);
            if (read > 0) {
                this.nextReadPosition += (long)read;
                this.setNextReadBlock();
            }
            return read;
        }
    }

    protected int readFullyDirect(byte[] buffer, int offset, int length) throws IOException {
        int nread;
        int nbytes;
        for (nread = 0; nread < length; nread += nbytes) {
            nbytes = this.getParentDataInputStream().read(buffer, offset + nread, length - nread);
            if (nbytes >= 0) continue;
            return nread;
        }
        return nread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        CachingInputStream cachingInputStream = this;
        synchronized (cachingInputStream) {
            long oldPos = this.getPos();
            try {
                this.seek(position);
                int n = this.readInternal(buffer, offset, length);
                return n;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                log.error((Object)String.format("Failed to read from rubix for file %s position %d length %d. Falling back to remote", this.remotePath, this.nextReadPosition, length), (Throwable)e);
                this.getParentDataInputStream().readFully(position, buffer, offset, length);
                int n = length;
                return n;
            }
            finally {
                this.seek(oldPos);
            }
        }
    }

    private int readInternal(byte[] buffer, int offset, int length) throws IOException, InterruptedException, ExecutionException {
        log.debug((Object)String.format("Got Read, currentPos: %d currentBlock: %d bufferOffset: %d length: %d of file : %s", this.nextReadPosition, this.nextReadBlock, offset, length, this.remotePath));
        if (this.nextReadPosition >= this.fileSize) {
            log.debug((Object)"Already at eof, returning");
            return -1;
        }
        long endBlock = (this.nextReadPosition + (long)(length - 1)) / (long)this.blockSize + 1L;
        final List<ReadRequestChain> readRequestChains = this.setupReadRequestChains(buffer, offset, endBlock, length, this.nextReadPosition, this.nextReadBlock);
        log.debug((Object)"Executing Chains");
        ImmutableList.Builder builder = ImmutableList.builder();
        int sizeRead = 0;
        for (ReadRequestChain readRequestChain : readRequestChains) {
            readRequestChain.lock();
            builder.add(readService.submit((Callable)readRequestChain));
        }
        ImmutableCollection futures = builder.build();
        for (ListenableFuture future : futures) {
            try {
                sizeRead = Math.addExact(sizeRead, Math.toIntExact((Long)future.get()));
            }
            catch (InterruptedException | ExecutionException e) {
                for (ReadRequestChain readRequestChain : readRequestChains) {
                    readRequestChain.cancel();
                }
                throw e;
            }
        }
        readService.execute(new Runnable(){

            @Override
            public void run() {
                CachingInputStream.this.updateCacheAndStats(readRequestChains);
            }
        });
        log.debug((Object)String.format("Read %d bytes", sizeRead));
        if (sizeRead > 0) {
            this.nextReadPosition += (long)sizeRead;
            this.setNextReadBlock();
            log.debug((Object)String.format("New nextReadPosition: %d nextReadBlock: %d", this.nextReadPosition, this.nextReadBlock));
        }
        return sizeRead;
    }

    void updateCacheAndStats(List<ReadRequestChain> readRequestChains) {
        ReadRequestChainStats stats = new ReadRequestChainStats();
        for (ReadRequestChain readRequestChain : readRequestChains) {
            readRequestChain.updateCacheStatus(this.remotePath, this.fileSize, this.lastModified, this.blockSize, this.conf);
            stats = stats.add(readRequestChain.getStats());
        }
        this.stats.addReadRequestChainStats(stats);
    }

    List<ReadRequestChain> setupReadRequestChains(byte[] buffer, int offset, long endBlock, int length, long nextReadPosition, long nextReadBlock) throws IOException {
        ImmutableList.Builder chainedReadRequestChainBuilder;
        block53: {
            HashMap<String, NonLocalRequestChain> nonLocalAsyncRequests;
            block52: {
                ReadRequestChain directReadRequestChain = null;
                ReadRequestChain remoteReadRequestChain = null;
                ReadRequestChain cachedReadRequestChain = null;
                ReadRequestChain remoteFetchRequestChain = null;
                HashMap<String, NonLocalReadRequestChain> nonLocalRequests = new HashMap<String, NonLocalReadRequestChain>();
                nonLocalAsyncRequests = new HashMap<String, NonLocalRequestChain>();
                chainedReadRequestChainBuilder = ImmutableList.builder();
                int lengthAlreadyConsidered = 0;
                List<BlockLocation> isCached = null;
                int generationNumber = 0;
                try {
                    RetryingPooledBookkeeperClient bookKeeperClient = this.bookKeeperFactory.createBookKeeperClient(this.conf);
                    Iterator iterator = null;
                    try {
                        CacheStatusRequest request = new CacheStatusRequest(this.remotePath, this.fileSize, this.lastModified, nextReadBlock, endBlock).setClusterType(this.clusterType.ordinal());
                        request.setIncrMetrics(true);
                        CacheStatusResponse response = bookKeeperClient.getCacheStatus(request);
                        isCached = response.getBlocks();
                        generationNumber = response.getGenerationNumber();
                    }
                    catch (Throwable request) {
                        iterator = request;
                        throw request;
                    }
                    finally {
                        if (bookKeeperClient != null) {
                            if (iterator != null) {
                                try {
                                    bookKeeperClient.close();
                                }
                                catch (Throwable request) {
                                    ((Throwable)((Object)iterator)).addSuppressed(request);
                                }
                            } else {
                                bookKeeperClient.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (this.strictMode) {
                        throw Throwables.propagate(e);
                    }
                    log.debug((Object)"Could not get cache status from server ", (Throwable)e);
                }
                int idx = 0;
                long blockNum = nextReadBlock;
                while (blockNum < endBlock) {
                    long actualReadEnd;
                    long backendReadStart = blockNum * (long)this.blockSize;
                    long backendReadEnd = (blockNum + 1L) * (long)this.blockSize;
                    if (backendReadStart >= this.fileSize) {
                        log.debug((Object)"Reached EOF, returning");
                        break;
                    }
                    if (backendReadEnd >= this.fileSize) {
                        backendReadEnd = this.fileSize;
                    }
                    long actualReadStart = blockNum == nextReadBlock ? nextReadPosition : backendReadStart;
                    long l = actualReadEnd = blockNum == endBlock - 1L ? nextReadPosition + (long)length : backendReadEnd;
                    if (actualReadEnd >= this.fileSize) {
                        actualReadEnd = this.fileSize;
                    }
                    int bufferOffest = offset + lengthAlreadyConsidered;
                    ReadRequest readRequest = new ReadRequest(backendReadStart, backendReadEnd, actualReadStart, actualReadEnd, buffer, bufferOffest, this.fileSize);
                    lengthAlreadyConsidered += readRequest.getActualReadLengthIntUnsafe();
                    if (isCached == null) {
                        log.debug((Object)String.format("Sending block %d to DirectReadRequestChain", blockNum));
                        if (directReadRequestChain == null) {
                            directReadRequestChain = new DirectReadRequestChain(this.getParentDataInputStream());
                        }
                        directReadRequestChain.addReadRequest(readRequest);
                    } else if (isCached.get(idx).getLocation() == Location.CACHED) {
                        log.debug((Object)String.format("Sending cached block %d to cachedReadRequestChain", blockNum));
                        if (cachedReadRequestChain == null) {
                            cachedReadRequestChain = new CachedReadRequestChain(this.remoteFileSystem, this.remotePath, bufferPool, this.diskReadBufferSize, this.statistics, this.conf, this.bookKeeperFactory, generationNumber);
                        }
                        cachedReadRequestChain.addReadRequest(readRequest);
                    } else if (isCached.get(idx).getLocation() == Location.NON_LOCAL) {
                        String remoteLocation = isCached.get(idx).getRemoteLocation();
                        if (CacheConfig.isParallelWarmupEnabled(this.conf)) {
                            log.debug((Object)String.format("Sending block %d to NonLocalRequestChain to node : %s", blockNum, remoteLocation));
                            if (!nonLocalAsyncRequests.containsKey(remoteLocation)) {
                                NonLocalRequestChain nonLocalRequestChain = new NonLocalRequestChain(remoteLocation, this.fileSize, this.lastModified, this.conf, this.remoteFileSystem, this.remotePath, this.clusterType.ordinal(), this.strictMode, this.statistics, nextReadBlock, endBlock, new BookKeeperFactory());
                                nonLocalAsyncRequests.put(remoteLocation, nonLocalRequestChain);
                            }
                            ((NonLocalRequestChain)nonLocalAsyncRequests.get(remoteLocation)).addReadRequest(readRequest);
                            if (((NonLocalRequestChain)nonLocalAsyncRequests.get(remoteLocation)).needDirectReadRequest(blockNum)) {
                                if (directReadRequestChain == null) {
                                    directReadRequestChain = new DirectReadRequestChain(this.getParentDataInputStream());
                                }
                                directReadRequestChain.addReadRequest(readRequest.clone(false));
                            }
                        } else {
                            log.debug((Object)String.format("Sending block %d to NonLocalReadRequestChain to node : %s", blockNum, remoteLocation));
                            if (!nonLocalRequests.containsKey(remoteLocation)) {
                                NonLocalReadRequestChain nonLocalReadRequestChain = new NonLocalReadRequestChain(remoteLocation, this.fileSize, this.lastModified, this.conf, this.remoteFileSystem, this.remotePath, this.clusterType.ordinal(), this.strictMode, this.statistics);
                                nonLocalRequests.put(remoteLocation, nonLocalReadRequestChain);
                            }
                            ((NonLocalReadRequestChain)nonLocalRequests.get(remoteLocation)).addReadRequest(readRequest);
                        }
                    } else if (CacheConfig.isParallelWarmupEnabled(this.conf)) {
                        log.debug((Object)String.format("Sending block %d to remoteFetchRequestChain", blockNum));
                        if (directReadRequestChain == null) {
                            directReadRequestChain = new DirectReadRequestChain(this.getParentDataInputStream());
                        }
                        if (remoteFetchRequestChain == null) {
                            remoteFetchRequestChain = new RemoteFetchRequestChain(this.remotePath, this.remoteFileSystem, "localhost", this.conf, this.lastModified, this.fileSize, this.clusterType.ordinal(), this.bookKeeperFactory);
                        }
                        directReadRequestChain.addReadRequest(readRequest);
                        remoteFetchRequestChain.addReadRequest(readRequest.clone(true));
                    } else {
                        log.debug((Object)String.format("Sending block %d to remoteReadRequestChain", blockNum));
                        if (this.affixBuffer == null) {
                            this.affixBuffer = new byte[this.blockSize];
                        }
                        if (remoteReadRequestChain == null) {
                            remoteReadRequestChain = new RemoteReadRequestChain(this.getParentDataInputStream(), this.remotePath, generationNumber, bufferPool, this.conf, this.affixBuffer, this.bookKeeperFactory);
                        }
                        remoteReadRequestChain.addReadRequest(readRequest);
                    }
                    ++blockNum;
                    ++idx;
                }
                if (cachedReadRequestChain != null) {
                    chainedReadRequestChainBuilder.add(cachedReadRequestChain);
                }
                if (!CacheConfig.isParallelWarmupEnabled(this.conf)) {
                    if (directReadRequestChain != null || remoteReadRequestChain != null) {
                        ChainedReadRequestChain shared = new ChainedReadRequestChain();
                        if (remoteReadRequestChain != null) {
                            shared.addReadRequestChain(remoteReadRequestChain);
                        }
                        if (directReadRequestChain != null) {
                            shared.addReadRequestChain(directReadRequestChain);
                        }
                        chainedReadRequestChainBuilder.add(shared);
                    }
                } else if (directReadRequestChain != null) {
                    if (directReadRequestChain != null) {
                        chainedReadRequestChainBuilder.add(directReadRequestChain);
                    }
                    if (remoteFetchRequestChain != null) {
                        chainedReadRequestChainBuilder.add(remoteFetchRequestChain);
                    }
                }
                if (CacheConfig.isParallelWarmupEnabled(this.conf)) break block52;
                if (nonLocalRequests.isEmpty()) break block53;
                for (NonLocalReadRequestChain nonLocalReadRequestChain1 : nonLocalRequests.values()) {
                    chainedReadRequestChainBuilder.add(nonLocalReadRequestChain1);
                }
                break block53;
            }
            if (!nonLocalAsyncRequests.isEmpty()) {
                for (NonLocalRequestChain item : nonLocalAsyncRequests.values()) {
                    chainedReadRequestChainBuilder.add(item);
                }
            }
        }
        return chainedReadRequestChainBuilder.build();
    }

    private void setNextReadBlock() {
        this.nextReadBlock = this.nextReadPosition / (long)this.blockSize;
    }

    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }
}

