/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixManager;
import org.apache.helix.api.status.ClusterManagementMode;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.ManagementControllerDataProvider;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.MessageGenerationPhase;
import org.apache.helix.controller.stages.MessageOutput;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.util.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementMessageGenerationPhase
extends MessageGenerationPhase {
    private static final Logger LOG = LoggerFactory.getLogger(ManagementMessageGenerationPhase.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        String clusterName = event.getClusterName();
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        ClusterManagementMode managementMode = (ClusterManagementMode)event.getAttribute(AttributeName.CLUSTER_STATUS.name());
        ManagementControllerDataProvider cache = (ManagementControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        if (manager == null || managementMode == null || cache == null) {
            throw new StageException("Missing attributes in event: " + event + ". Requires HelixManager|ClusterStatus|DataCache");
        }
        PauseSignal pauseSignal = cache.getPauseSignal();
        if (cache.getClusterConfig().isStateTransitionCancelEnabled() && pauseSignal != null && pauseSignal.getCancelPendingST()) {
            LogUtil.logInfo(LOG, this._eventId, "Generating ST cancellation messages for cluster " + clusterName);
            super.process(event);
        }
        MessageOutput messageOutput = event.getAttributeWithDefault(AttributeName.MESSAGES_ALL.name(), new MessageOutput());
        if (!ClusterManagementMode.Status.COMPLETED.equals((Object)managementMode.getStatus())) {
            LogUtil.logInfo(LOG, this._eventId, "Generating messages as cluster " + clusterName + " is still in progress to change participant status");
            List<Message> messages = this.generateStatusChangeMessages(managementMode, cache.getEnabledLiveInstances(), cache.getLiveInstances(), cache.getAllInstancesMessages(), manager.getInstanceName(), manager.getSessionId());
            messageOutput.addStatusChangeMessages(messages);
        }
        event.addAttribute(AttributeName.MESSAGES_ALL.name(), messageOutput);
    }

    private List<Message> generateStatusChangeMessages(ClusterManagementMode managementMode, Set<String> enabledLiveInstances, Map<String, LiveInstance> liveInstanceMap, Map<String, Collection<Message>> allInstanceMessages, String managerInstance, String managerSessionId) {
        ArrayList<Message> messagesGenerated = new ArrayList<Message>();
        LiveInstance.LiveInstanceStatus desiredStatus = managementMode.getDesiredParticipantStatus();
        for (String instanceName : enabledLiveInstances) {
            LiveInstance liveInstance = liveInstanceMap.get(instanceName);
            Collection<Message> pendingMessages = allInstanceMessages.get(instanceName);
            String sessionId = liveInstance.getEphemeralOwner();
            LiveInstance.LiveInstanceStatus currentStatus = liveInstance.getStatus();
            if (!this.needStatusChangeMessage(pendingMessages, currentStatus, desiredStatus)) continue;
            Message statusChangeMessage = MessageUtil.createStatusChangeMessage(currentStatus, desiredStatus, managerInstance, managerSessionId, instanceName, sessionId);
            messagesGenerated.add(statusChangeMessage);
        }
        return messagesGenerated;
    }

    private boolean needStatusChangeMessage(Collection<Message> messages, LiveInstance.LiveInstanceStatus currentStatus, LiveInstance.LiveInstanceStatus desiredStatus) {
        return currentStatus != desiredStatus && messages.stream().noneMatch(message -> message.isParticipantStatusChangeType() && desiredStatus.name().equals(message.getToState()));
    }
}

