/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpch;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.tpch.DecimalTypeMapping;
import io.trino.plugin.tpch.TpchMetadata;
import io.trino.plugin.tpch.TpchRecordSet;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.tpch.TpchTable;
import java.util.Iterator;
import java.util.List;

public final class TpchTables {
    private TpchTables() {
    }

    public static List<Type> getTableColumns(String tableName, DecimalTypeMapping decimalTypeMapping) {
        TpchTable table = TpchTable.getTable((String)tableName);
        return (List)table.getColumns().stream().map(column -> TpchMetadata.getTrinoType(column, decimalTypeMapping)).collect(ImmutableList.toImmutableList());
    }

    public static Iterator<Page> getTablePages(String tableName, double scaleFactor, DecimalTypeMapping decimalTypeMapping) {
        TpchTable table = TpchTable.getTable((String)tableName);
        RecordPageSource pageSource = new RecordPageSource(TpchRecordSet.createTpchRecordSet(table, decimalTypeMapping, scaleFactor, 1, 1, (TupleDomain<ColumnHandle>)TupleDomain.all()));
        return new AbstractIterator<Page>((ConnectorPageSource)pageSource){
            final /* synthetic */ ConnectorPageSource val$pageSource;
            {
                this.val$pageSource = connectorPageSource;
            }

            protected Page computeNext() {
                if (this.val$pageSource.isFinished()) {
                    return (Page)this.endOfData();
                }
                Page page = this.val$pageSource.getNextPage();
                if (page == null) {
                    return this.computeNext();
                }
                return page.getLoadedPage();
            }
        };
    }
}

