/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class CassandraInsertTableHandle
implements ConnectorInsertTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private final boolean generateUuid;

    @JsonCreator
    public CassandraInsertTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="columnTypes") List<Type> columnTypes, @JsonProperty(value="generateUuid") boolean generateUuid) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Objects.requireNonNull(columnTypes, "columnTypes is null");
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes sizes don't match");
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.columnTypes = ImmutableList.copyOf(columnTypes);
        this.generateUuid = generateUuid;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @JsonProperty
    public boolean isGenerateUuid() {
        return this.generateUuid;
    }

    public String toString() {
        return "cassandra:" + this.schemaName + "." + this.tableName;
    }
}

