/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.airlift.log.Logger;
import io.trino.plugin.cassandra.CassandraColumnHandle;
import io.trino.plugin.cassandra.CassandraNamedRelationHandle;
import io.trino.plugin.cassandra.CassandraPartition;
import io.trino.plugin.cassandra.CassandraPartitionResult;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.plugin.cassandra.CassandraTable;
import io.trino.plugin.cassandra.CassandraType;
import io.trino.plugin.cassandra.CassandraTypeManager;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public class CassandraPartitionManager {
    private static final Logger log = Logger.get(CassandraPartitionManager.class);
    private final CassandraSession cassandraSession;
    private final CassandraTypeManager cassandraTypeManager;

    @Inject
    public CassandraPartitionManager(CassandraSession cassandraSession, CassandraTypeManager cassandraTypeManager) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
        this.cassandraTypeManager = Objects.requireNonNull(cassandraTypeManager, "cassandraTypeManager is null");
    }

    public CassandraPartitionResult getPartitions(CassandraNamedRelationHandle cassandraTableHandle, TupleDomain<ColumnHandle> tupleDomain) {
        Preconditions.checkArgument((boolean)cassandraTableHandle.getPartitions().isEmpty(), (Object)"getPartitions() currently does not take into account table handle's partitions");
        CassandraTable table = this.cassandraSession.getTable(cassandraTableHandle.getSchemaTableName());
        List<CassandraPartition> allPartitions = this.getCassandraPartitions(table, tupleDomain);
        log.debug("%s.%s #partitions: %d", new Object[]{cassandraTableHandle.getSchemaName(), cassandraTableHandle.getTableName(), allPartitions.size()});
        List<CassandraPartition> partitions = allPartitions.stream().filter(partition -> tupleDomain.overlaps(partition.getTupleDomain())).collect(Collectors.toList());
        TupleDomain remainingTupleDomain = TupleDomain.none();
        if (!tupleDomain.isNone()) {
            if (partitions.size() == 1 && ((CassandraPartition)partitions.get(0)).isUnpartitioned()) {
                remainingTupleDomain = tupleDomain;
            } else {
                Set usedPartitionColumns = (Set)partitions.stream().flatMap(partition -> Optional.ofNullable(partition.getTupleDomain()).flatMap(partitionTupleDomain -> partitionTupleDomain.getDomains().map(Map::keySet).map(Collection::stream)).orElseGet(Stream::empty)).collect(ImmutableSet.toImmutableSet());
                remainingTupleDomain = tupleDomain.filter((column, domain) -> !usedPartitionColumns.contains(column));
            }
        }
        if (partitions.size() == 1 && ((CassandraPartition)partitions.get(0)).isUnpartitioned()) {
            Map domains = (Map)tupleDomain.getDomains().get();
            ArrayList<CassandraColumnHandle> indexedColumns = new ArrayList<CassandraColumnHandle>();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : domains.entrySet()) {
                CassandraColumnHandle column2 = (CassandraColumnHandle)entry.getKey();
                Domain domain2 = (Domain)entry.getValue();
                if (!column2.isIndexed() || !domain2.isSingleValue()) continue;
                sb.append(CassandraCqlUtils.validColumnName(column2.getName())).append(" = ").append(this.cassandraTypeManager.toCqlLiteral(column2.getCassandraType(), ((Domain)entry.getValue()).getSingleValue()));
                indexedColumns.add(column2);
                break;
            }
            if (sb.length() > 0) {
                CassandraPartition partition2 = partitions.get(0);
                TupleDomain filterIndexedColumn = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)remainingTupleDomain.getDomains().get()), (Predicate)Predicates.not((Predicate)Predicates.in(indexedColumns))));
                partitions = new ArrayList<CassandraPartition>();
                partitions.add(new CassandraPartition(partition2.getKey(), sb.toString(), (TupleDomain<ColumnHandle>)filterIndexedColumn, true));
                return new CassandraPartitionResult(partitions, (TupleDomain<ColumnHandle>)filterIndexedColumn);
            }
        }
        return new CassandraPartitionResult(partitions, (TupleDomain<ColumnHandle>)remainingTupleDomain);
    }

    private List<CassandraPartition> getCassandraPartitions(CassandraTable table, TupleDomain<ColumnHandle> tupleDomain) {
        if (tupleDomain.isNone()) {
            return ImmutableList.of();
        }
        List<Set<Object>> partitionKeysList = this.getPartitionKeysList(table, tupleDomain);
        Set filterList = Sets.cartesianProduct(partitionKeysList);
        if (filterList.isEmpty()) {
            return this.cassandraSession.getPartitions(table, (List<Set<Object>>)ImmutableList.of());
        }
        return this.cassandraSession.getPartitions(table, partitionKeysList);
    }

    private List<Set<Object>> getPartitionKeysList(CassandraTable table, TupleDomain<ColumnHandle> tupleDomain) {
        ImmutableList.Builder partitionColumnValues = ImmutableList.builder();
        for (CassandraColumnHandle columnHandle : table.getPartitionKeyColumns()) {
            Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(columnHandle);
            if (domain == null) {
                return ImmutableList.of();
            }
            if (domain.isNullAllowed()) {
                return ImmutableList.of();
            }
            Set values = (Set)domain.getValues().getValuesProcessor().transform(ranges -> {
                ImmutableSet.Builder columnValues = ImmutableSet.builder();
                for (Range range : ranges.getOrderedRanges()) {
                    if (!range.isSingleValue()) {
                        return ImmutableSet.of();
                    }
                    Object value = range.getSingleValue();
                    CassandraType valueType = columnHandle.getCassandraType();
                    if (!this.cassandraTypeManager.isSupportedPartitionKey(valueType.getKind())) continue;
                    columnValues.add(value);
                }
                return columnValues.build();
            }, discreteValues -> {
                if (discreteValues.isInclusive()) {
                    return ImmutableSet.copyOf((Collection)discreteValues.getValues());
                }
                return ImmutableSet.of();
            }, allOrNone -> ImmutableSet.of());
            partitionColumnValues.add((Object)values);
        }
        return partitionColumnValues.build();
    }
}

