/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.plugin.cassandra.CassandraNamedRelationHandle;
import io.trino.plugin.cassandra.CassandraRelationHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import java.util.Objects;

public class CassandraTableHandle
implements ConnectorTableHandle {
    private final CassandraRelationHandle relationHandle;

    @JsonCreator
    public CassandraTableHandle(@JsonProperty(value="relationHandle") CassandraRelationHandle relationHandle) {
        this.relationHandle = Objects.requireNonNull(relationHandle, "relationHandle is null");
    }

    @JsonProperty
    public CassandraRelationHandle getRelationHandle() {
        return this.relationHandle;
    }

    @JsonIgnore
    public CassandraNamedRelationHandle getRequiredNamedRelation() {
        Preconditions.checkState((boolean)this.isNamedRelation(), (String)"The table handle does not represent a named relation: %s", (Object)this);
        return (CassandraNamedRelationHandle)this.relationHandle;
    }

    @JsonIgnore
    public boolean isSynthetic() {
        return !this.isNamedRelation();
    }

    @JsonIgnore
    public boolean isNamedRelation() {
        return this.relationHandle instanceof CassandraNamedRelationHandle;
    }

    public int hashCode() {
        return Objects.hash(this.relationHandle);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CassandraTableHandle other = (CassandraTableHandle)obj;
        return Objects.equals(this.relationHandle, other.relationHandle);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relationHandle", (Object)this.relationHandle).toString();
    }
}

