/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorTableFunction;
import io.trino.plugin.cassandra.CassandraColumnHandle;
import io.trino.plugin.cassandra.CassandraMetadata;
import io.trino.plugin.cassandra.CassandraQueryRelationHandle;
import io.trino.plugin.cassandra.CassandraTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.ptf.AbstractConnectorTableFunction;
import io.trino.spi.ptf.Argument;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.ptf.ConnectorTableFunctionHandle;
import io.trino.spi.ptf.Descriptor;
import io.trino.spi.ptf.ReturnTypeSpecification;
import io.trino.spi.ptf.ScalarArgument;
import io.trino.spi.ptf.ScalarArgumentSpecification;
import io.trino.spi.ptf.TableFunctionAnalysis;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;

public class Query
implements Provider<ConnectorTableFunction> {
    public static final String SCHEMA_NAME = "system";
    public static final String NAME = "query";
    private final CassandraMetadata cassandraMetadata;

    @Inject
    public Query(CassandraMetadata cassandraMetadata) {
        this.cassandraMetadata = Objects.requireNonNull(cassandraMetadata, "cassandraMetadata is null");
    }

    public ConnectorTableFunction get() {
        return new ClassLoaderSafeConnectorTableFunction((ConnectorTableFunction)new QueryFunction(this.cassandraMetadata), this.getClass().getClassLoader());
    }

    public static class QueryFunction
    extends AbstractConnectorTableFunction {
        private final CassandraMetadata cassandraMetadata;

        public QueryFunction(CassandraMetadata cassandraMetadata) {
            super(Query.SCHEMA_NAME, Query.NAME, (List)ImmutableList.of((Object)ScalarArgumentSpecification.builder().name("QUERY").type((Type)VarcharType.VARCHAR).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
            this.cassandraMetadata = Objects.requireNonNull(cassandraMetadata, "metadata is null");
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments) {
            ScalarArgument argument = (ScalarArgument)Iterables.getOnlyElement(arguments.values());
            String query = ((Slice)argument.getValue()).toStringUtf8();
            CassandraQueryRelationHandle queryRelationHandle = new CassandraQueryRelationHandle(query);
            List<ColumnHandle> columnHandles = this.cassandraMetadata.getColumnHandles(query);
            Preconditions.checkState((!columnHandles.isEmpty() ? 1 : 0) != 0, (Object)"Handle doesn't have columns info");
            Descriptor returnedType = new Descriptor((List)columnHandles.stream().map(CassandraColumnHandle.class::cast).map(column -> new Descriptor.Field(column.getName(), Optional.of(column.getType()))).collect(ImmutableList.toImmutableList()));
            QueryHandle handle = new QueryHandle(new CassandraTableHandle(queryRelationHandle));
            return TableFunctionAnalysis.builder().returnedType(returnedType).handle((ConnectorTableFunctionHandle)handle).build();
        }
    }

    public static class QueryHandle
    implements ConnectorTableFunctionHandle {
        private final CassandraTableHandle tableHandle;

        @JsonCreator
        public QueryHandle(@JsonProperty(value="tableHandle") CassandraTableHandle tableHandle) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        }

        @JsonProperty
        public CassandraTableHandle getTableHandle() {
            return this.tableHandle;
        }
    }
}

