/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.functions;

import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class TrinoKeywordsConverter {
    private static final Set<String> RESERVED_KEYWORDS = ImmutableSet.of((Object)"ALTER", (Object)"AND", (Object)"AS", (Object)"BETWEEN", (Object)"BY", (Object)"CASE", (Object[])new String[]{"CAST", "CONSTRAINT", "CREATE", "CROSS", "CUBE", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEALLOCATE", "DELETE", "DESCRIBE", "DISTINCT", "DROP", "ELSE", "END", "ESCAPE", "EXCEPT", "EXECUTE", "EXISTS", "EXTRACT", "FALSE", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "HAVING", "IN", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "LEFT", "LIKE", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NORMALIZE", "NOT", "NULL", "ON", "OR", "ORDER", "OUTER", "PREPARE", "RECURSIVE", "RIGHT", "ROLLUP", "SELECT", "TABLE", "THEN", "TRUE", "UESCAPE", "UNION", "UNNEST", "USING", "VALUES", "WHEN", "WHERE", "WITH"});

    private TrinoKeywordsConverter() {
    }

    public static String quoteReservedKeyword(String value) {
        if (RESERVED_KEYWORDS.contains(value.toUpperCase())) {
            return TrinoKeywordsConverter.quoteWordIfNotQuoted(value);
        }
        return value;
    }

    public static String quoteWordIfNotQuoted(String value) {
        return value.startsWith("\"") && value.endsWith("\"") ? value : "\"" + value + "\"";
    }
}

