/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.client;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.IndexDefinition;
import org.apache.ignite.internal.cache.query.index.IndexFactory;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.client.ClientIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.client.ClientInlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyTypeRegistry;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexTree;
import org.apache.ignite.internal.processors.cache.GridCacheContext;

public class ClientIndexFactory
implements IndexFactory {
    private static final IndexKeyTypeSettings DUMMY_SETTINGS = new IndexKeyTypeSettings();
    private final IgniteLogger log;

    public ClientIndexFactory(IgniteLogger log) {
        this.log = log;
    }

    @Override
    public Index createIndex(GridCacheContext<?, ?> cctx, IndexDefinition definition) {
        ClientIndexDefinition def = (ClientIndexDefinition)definition;
        LinkedHashMap<String, IndexKeyDefinition> keyDefs = definition.indexKeyDefinitions();
        List<InlineIndexKeyType> keyTypes = InlineIndexKeyTypeRegistry.types(keyDefs.values(), DUMMY_SETTINGS);
        int inlineSize = InlineIndexTree.computeInlineSize(definition.idxName().fullName(), keyTypes, new ArrayList<IndexKeyDefinition>(keyDefs.values()), def.getCfgInlineSize(), def.getMaxInlineSize(), this.log);
        return new ClientInlineIndex(def.idxName().idxName(), inlineSize);
    }
}

