/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.client.ClientAutoCloseableIterator;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientIgniteSet;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;

class ClientIgniteSetImpl<T>
implements ClientIgniteSet<T> {
    private final String name;
    private final ReliableChannel ch;
    private final ClientUtils serDes;
    private final boolean colocated;
    private final int cacheId;
    private volatile boolean serverKeepBinary = true;
    private volatile int pageSize = 1024;

    public ClientIgniteSetImpl(ReliableChannel ch, ClientUtils serDes, String name, boolean colocated, int cacheId) {
        assert (ch != null);
        assert (serDes != null);
        assert (name != null);
        this.ch = ch;
        this.serDes = serDes;
        this.name = name;
        this.colocated = colocated;
        this.cacheId = cacheId;
    }

    @Override
    public boolean add(T o) {
        A.notNull(o, "o");
        return this.singleKeyOp(ClientOperation.OP_SET_VALUE_ADD, o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        A.notNull(c, "c");
        return this.multiKeyOp(ClientOperation.OP_SET_VALUE_ADD_ALL, c);
    }

    @Override
    public void clear() {
        this.op(ClientOperation.OP_SET_CLEAR, null, null);
    }

    @Override
    public boolean contains(Object o) {
        A.notNull(o, "o");
        return this.singleKeyOp(ClientOperation.OP_SET_VALUE_CONTAINS, o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        A.notNull(c, "c");
        return this.multiKeyOp(ClientOperation.OP_SET_VALUE_CONTAINS_ALL, c);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ClientAutoCloseableIterator<T> iterator() {
        Consumer<PayloadOutputChannel> payloadWriter = out -> {
            this.writeIdentity((PayloadOutputChannel)out);
            out.out().writeInt(this.pageSize);
        };
        Function<PayloadInputChannel, ClientAutoCloseableIterator> payloadReader = in -> {
            List<T> page = this.readPage((PayloadInputChannel)in);
            boolean hasNext = in.in().readBoolean();
            Long resourceId = hasNext ? Long.valueOf(in.in().readLong()) : null;
            ClientChannel resourceCh = hasNext ? in.clientChannel() : null;
            return new PagedIterator(resourceCh, resourceId, page);
        };
        if (this.colocated) {
            Integer affinityKey = this.name.hashCode();
            return this.ch.affinityService(this.cacheId, affinityKey, ClientOperation.OP_SET_ITERATOR_START, payloadWriter, payloadReader);
        }
        return this.ch.service(ClientOperation.OP_SET_ITERATOR_START, payloadWriter, payloadReader);
    }

    @Override
    public boolean remove(Object o) {
        A.notNull(o, "o");
        return this.singleKeyOp(ClientOperation.OP_SET_VALUE_REMOVE, o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        A.notNull(c, "c");
        return this.multiKeyOp(ClientOperation.OP_SET_VALUE_REMOVE_ALL, c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        A.notNull(c, "c");
        if (c.isEmpty()) {
            return this.ch.service(ClientOperation.OP_SET_VALUE_RETAIN_ALL, out -> {
                try (BinaryRawWriterEx w = this.serDes.createBinaryWriter(out.out());){
                    this.writeIdentity(w);
                    w.writeBoolean(this.serverKeepBinary);
                    w.writeInt(0);
                }
            }, r -> r.in().readBoolean());
        }
        return this.multiKeyOp(ClientOperation.OP_SET_VALUE_RETAIN_ALL, c);
    }

    @Override
    public int size() {
        return this.op(ClientOperation.OP_SET_SIZE, null, r -> r.in().readInt());
    }

    @Override
    public Object[] toArray() {
        return this.toArray((T1[])X.EMPTY_OBJECT_ARRAY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T1> T1[] toArray(T1[] a) {
        try (Iterator it = this.iterator();){
            ArrayList res = new ArrayList();
            while (it.hasNext()) {
                res.add(it.next());
            }
            T1[] T1Array = res.toArray(a);
            return T1Array;
        }
        catch (Exception e) {
            throw new IgniteClientException(1, e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        this.op(ClientOperation.OP_SET_CLOSE, null, null);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean colocated() {
        return this.colocated;
    }

    @Override
    public boolean removed() {
        return this.op(ClientOperation.OP_SET_EXISTS, null, r -> r.in().readBoolean()) == false;
    }

    @Override
    public ClientIgniteSet<T> serverKeepBinary(boolean keepBinary) {
        this.serverKeepBinary = keepBinary;
        return this;
    }

    @Override
    public boolean serverKeepBinary() {
        return this.serverKeepBinary;
    }

    @Override
    public ClientIgniteSet<T> pageSize(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page size must be greater than 0.");
        }
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    private Boolean singleKeyOp(ClientOperation op, Object key) {
        Object affKey = this.affinityKey(key);
        return this.ch.affinityService(this.cacheId, affKey, op, out -> {
            try (BinaryRawWriterEx w = this.serDes.createBinaryWriter(out.out());){
                this.writeIdentity(w);
                w.writeBoolean(this.serverKeepBinary);
                w.writeObject(key);
            }
        }, r -> r.in().readBoolean());
    }

    private Boolean multiKeyOp(ClientOperation op, Collection keys) {
        if (keys.isEmpty()) {
            return false;
        }
        Iterator iter = keys.iterator();
        Object firstKey = iter.next();
        Object affKey = this.affinityKey(firstKey);
        return this.ch.affinityService(this.cacheId, affKey, op, out -> {
            try (BinaryRawWriterEx w = this.serDes.createBinaryWriter(out.out());){
                this.writeIdentity(w);
                w.writeBoolean(this.serverKeepBinary);
                w.writeInt(keys.size());
                w.writeObject(firstKey);
                while (iter.hasNext()) {
                    w.writeObject(iter.next());
                }
            }
        }, r -> r.in().readBoolean());
    }

    private <TR> TR op(ClientOperation op, Consumer<BinaryRawWriterEx> writer, Function<PayloadInputChannel, TR> reader) {
        return this.ch.service(op, out -> {
            try (BinaryRawWriterEx w = this.serDes.createBinaryWriter(out.out());){
                this.writeIdentity(w);
                if (writer != null) {
                    writer.accept(w);
                }
            }
        }, reader);
    }

    private void writeIdentity(PayloadOutputChannel out) {
        try (BinaryRawWriterEx w = this.serDes.createBinaryWriter(out.out());){
            this.writeIdentity(w);
        }
    }

    private void writeIdentity(BinaryRawWriterEx w) {
        w.writeString(this.name);
        w.writeInt(this.cacheId);
        w.writeBoolean(this.colocated);
    }

    private Object affinityKey(Object key) {
        if (this.colocated) {
            return this.name.hashCode();
        }
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<T> readPage(PayloadInputChannel in) {
        try (BinaryReaderExImpl r = this.serDes.createBinaryReader(in.in());){
            int size = r.readInt();
            ArrayList<Object> res = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                res.add(r.readObject());
            }
            ArrayList<Object> arrayList = res;
            return arrayList;
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    private class PagedIterator
    implements ClientAutoCloseableIterator<T> {
        private final ClientChannel resourceCh;
        private Long resourceId;
        private List<T> page;
        private int pos;

        public PagedIterator(ClientChannel resourceCh, Long resourceId, List<T> page) {
            assert (page != null);
            assert (resourceCh == null == (resourceId == null));
            this.resourceCh = resourceCh;
            this.resourceId = resourceId;
            this.page = page;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.page.size();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object next = this.page.get(this.pos++);
            if (this.pos >= this.page.size() && this.resourceId != null) {
                this.fetchNextPage();
            }
            return next;
        }

        @Override
        public void close() throws Exception {
            Long id = this.resourceId;
            if (id == null) {
                return;
            }
            ClientIgniteSetImpl.this.ch.service(ClientOperation.RESOURCE_CLOSE, w -> w.out().writeLong(id), null);
            this.resourceId = null;
            this.pos = Integer.MAX_VALUE;
        }

        private void fetchNextPage() {
            this.page = this.resourceCh.service(ClientOperation.OP_SET_ITERATOR_GET_PAGE, out -> {
                out.out().writeLong(this.resourceId);
                out.out().writeInt(ClientIgniteSetImpl.this.pageSize);
            }, in -> {
                List res = ClientIgniteSetImpl.this.readPage(in);
                boolean hasNext = in.in().readBoolean();
                if (!hasNext) {
                    this.resourceId = null;
                }
                return res;
            });
            this.pos = 0;
        }
    }
}

