/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperationRequest;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.mxbean.SnapshotMXBean;

public class SnapshotMXBeanImpl
implements SnapshotMXBean {
    private final IgniteSnapshotManager mgr;
    private final GridMetricManager metricMgr;

    public SnapshotMXBeanImpl(GridKernalContext ctx) {
        this.mgr = ctx.cache().context().snapshotMgr();
        this.metricMgr = ctx.metric();
    }

    @Override
    public void createSnapshot(String snpName, String snpPath) {
        IgniteFuture<Void> fut = this.mgr.createSnapshot(snpName, F.isEmpty(snpPath) ? null : snpPath);
        if (fut.isDone()) {
            fut.get();
        }
    }

    @Override
    public void cancelSnapshot(String snpName) {
        this.mgr.cancelSnapshot(snpName).get();
    }

    @Override
    public void restoreSnapshot(String name, String path, String grpNames) {
        Set<String> grpNamesSet = F.isEmpty(grpNames) ? null : Arrays.stream(grpNames.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        IgniteFuture<Void> fut = this.mgr.restoreSnapshot(name, F.isEmpty(path) ? null : path, grpNamesSet);
        if (fut.isDone()) {
            fut.get();
        }
    }

    @Override
    public void cancelSnapshotRestore(String name) {
        this.mgr.cancelSnapshotRestore(name).get();
    }

    @Override
    public String status() {
        SnapshotOperationRequest req = this.mgr.currentCreateRequest();
        if (req != null) {
            return "Create snapshot operation is in progress [name=" + req.snapshotName() + ", id=" + req.requestId() + ']';
        }
        if (this.mgr.isRestoring()) {
            MetricRegistry mreg = this.metricMgr.registry("snapshot-restore");
            String name = mreg.findMetric("snapshotName").getAsString();
            String id = mreg.findMetric("requestId").getAsString();
            return "Restore snapshot operation is in progress [name=" + name + ", id=" + id + ']';
        }
        return "There is no create or restore snapshot operation in progress.";
    }
}

