/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotVerifyException;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadataCollectorTaskArg;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class SnapshotMetadataCollectorTask
extends ComputeTaskAdapter<SnapshotMetadataCollectorTaskArg, Map<ClusterNode, List<SnapshotMetadata>>> {
    private static final long serialVersionUID = 0L;

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, final SnapshotMetadataCollectorTaskArg arg) throws IgniteException {
        HashMap<1, ClusterNode> map = U.newHashMap(subgrid.size());
        for (ClusterNode node : subgrid) {
            map.put(new ComputeJobAdapter(){
                @IgniteInstanceResource
                private transient IgniteEx ignite;

                @Override
                public List<SnapshotMetadata> execute() throws IgniteException {
                    return this.ignite.context().cache().context().snapshotMgr().readSnapshotMetadatas(arg.snapshotName(), arg.snapshotPath());
                }
            }, node);
        }
        return map;
    }

    @Override
    @Nullable
    public Map<ClusterNode, List<SnapshotMetadata>> reduce(List<ComputeJobResult> results) throws IgniteException {
        HashMap<ClusterNode, List<SnapshotMetadata>> reduceRes = new HashMap<ClusterNode, List<SnapshotMetadata>>();
        HashMap<ClusterNode, IgniteException> exs = new HashMap<ClusterNode, IgniteException>();
        SnapshotMetadata first = null;
        for (ComputeJobResult res : results) {
            if (res.getException() != null) {
                exs.put(res.getNode(), res.getException());
                continue;
            }
            List metas = (List)res.getData();
            for (SnapshotMetadata meta : metas) {
                if (first == null) {
                    first = meta;
                }
                if (!first.sameSnapshot(meta)) {
                    exs.put(res.getNode(), new IgniteException("An error occurred during comparing snapshot metadata from cluster nodes [first=" + first + ", meta=" + meta + ", nodeId=" + res.getNode().id() + ']'));
                    continue;
                }
                reduceRes.computeIfAbsent(res.getNode(), n -> new ArrayList()).add(meta);
            }
        }
        if (exs.isEmpty()) {
            return reduceRes;
        }
        throw new IgniteSnapshotVerifyException(exs);
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        return ComputeJobResultPolicy.WAIT;
    }
}

