/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.encryption.EncryptionCacheKeyProvider;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandler;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerType;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyUtility;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class SnapshotPartitionsVerifyHandler
implements SnapshotHandler<Map<PartitionKeyV2, PartitionHashRecordV2>> {
    private final GridCacheSharedContext<?, ?> cctx;
    private final IgniteLogger log;

    public SnapshotPartitionsVerifyHandler(GridCacheSharedContext<?, ?> cctx) {
        this.cctx = cctx;
        this.log = cctx.logger(this.getClass());
    }

    @Override
    public SnapshotHandlerType type() {
        return SnapshotHandlerType.RESTORE;
    }

    @Override
    public Map<PartitionKeyV2, PartitionHashRecordV2> invoke(SnapshotHandlerContext opCtx) throws IgniteCheckedException {
        if (!opCtx.snapshotDirectory().exists()) {
            throw new IgniteCheckedException("Snapshot directory doesn't exists: " + opCtx.snapshotDirectory());
        }
        SnapshotMetadata meta = opCtx.metadata();
        HashSet<Integer> grps = F.isEmpty(opCtx.groups()) ? new HashSet<Integer>(meta.partitions().keySet()) : opCtx.groups().stream().map(GridCacheUtils::cacheId).collect(Collectors.toSet());
        HashSet<File> partFiles = new HashSet<File>();
        HashMap<Integer, File> grpDirs = new HashMap<Integer, File>();
        for (File dir : FilePageStoreManager.cacheDirectories(new File(opCtx.snapshotDirectory(), IgniteSnapshotManager.databaseRelativePath(meta.folderName())), name -> true)) {
            int grpId = CU.cacheId(FilePageStoreManager.cacheGroupName(dir));
            if (!grps.remove(grpId)) continue;
            HashSet parts = meta.partitions().get(grpId) == null ? Collections.emptySet() : new HashSet(meta.partitions().get(grpId));
            for (File part2 : FilePageStoreManager.cachePartitionFiles(dir)) {
                int partId = FilePageStoreManager.partId(part2.getName());
                if (!parts.remove(partId)) continue;
                partFiles.add(part2);
            }
            if (!parts.isEmpty()) {
                throw new IgniteException("Snapshot data doesn't contain required cache group partition [grpId=" + grpId + ", snpName=" + meta.snapshotName() + ", consId=" + meta.consistentId() + ", missed=" + parts + ", meta=" + meta + ']');
            }
            grpDirs.put(grpId, dir);
        }
        if (!grps.isEmpty()) {
            throw new IgniteException("Snapshot data doesn't contain required cache groups [grps=" + grps + ", snpName=" + meta.snapshotName() + ", consId=" + meta.consistentId() + ", meta=" + meta + ']');
        }
        ConcurrentHashMap<PartitionKeyV2, PartitionHashRecordV2> res = new ConcurrentHashMap<PartitionKeyV2, PartitionHashRecordV2>();
        ThreadLocal<ByteBuffer> buff = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(meta.pageSize()).order(ByteOrder.nativeOrder()));
        IgniteSnapshotManager snpMgr = this.cctx.snapshotMgr();
        StandaloneGridKernalContext snpCtx = snpMgr.createStandaloneKernalContext(opCtx.snapshotDirectory(), meta.folderName());
        FilePageStoreManager storeMgr = (FilePageStoreManager)this.cctx.pageStore();
        SnapshotEncryptionKeyProvider snpEncrKeyProvider = new SnapshotEncryptionKeyProvider(this.cctx.kernalContext(), grpDirs);
        for (GridComponent comp : snpCtx) {
            comp.start();
        }
        try {
            U.doInParallel(snpMgr.snapshotExecutorService(), partFiles, part -> {
                String grpName = FilePageStoreManager.cacheGroupName(part.getParentFile());
                int grpId = CU.cacheId(grpName);
                int partId = FilePageStoreManager.partId(part.getName());
                try (FilePageStore pageStore = (FilePageStore)storeMgr.getPageStoreFactory(grpId, snpEncrKeyProvider.getActiveKey(grpId) != null ? snpEncrKeyProvider : null).createPageStore(GroupPartitionId.getTypeByPartId(partId), part::toPath, val -> {});){
                    if (partId == 65535) {
                        IdleVerifyUtility.checkPartitionsPageCrcSum(() -> pageStore, 65535, (byte)2);
                        Object var14_15 = null;
                        return var14_15;
                    }
                    if (grpId == MetaStorage.METASTORAGE_CACHE_ID) {
                        IdleVerifyUtility.checkPartitionsPageCrcSum(() -> pageStore, partId, (byte)1);
                        Object var14_16 = null;
                        return var14_16;
                    }
                    ByteBuffer pageBuff = (ByteBuffer)buff.get();
                    pageBuff.clear();
                    pageStore.read(0L, pageBuff, true);
                    long pageAddr = GridUnsafe.bufferAddress(pageBuff);
                    PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(pageBuff);
                    GridDhtPartitionState partState = GridDhtPartitionState.fromOrdinal(io.getPartitionState(pageAddr));
                    if (partState != GridDhtPartitionState.OWNING) {
                        throw new IgniteCheckedException("Snapshot partitions must be in the OWNING state only: " + (Object)((Object)partState));
                    }
                    long updateCntr = io.getUpdateCounter(pageAddr);
                    long size = io.getSize(pageAddr);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partition [grpId=" + grpId + ", id=" + partId + ", counter=" + updateCntr + ", size=" + size + "]");
                    }
                    PartitionKeyV2 key = new PartitionKeyV2(grpId, partId, grpName);
                    PartitionHashRecordV2 hash = IdleVerifyUtility.calculatePartitionHash(key, updateCntr, meta.consistentId(), GridDhtPartitionState.OWNING, false, size, snpMgr.partitionRowIterator(snpCtx, grpName, partId, pageStore));
                    assert (hash != null) : "OWNING must have hash: " + key;
                    res.put(key, hash);
                    return null;
                }
                catch (IOException e) {
                    throw new IgniteCheckedException(e);
                }
            });
        }
        catch (Throwable t) {
            this.log.error("Error executing handler: ", t);
            throw t;
        }
        finally {
            for (GridComponent comp : snpCtx) {
                comp.stop(true);
            }
        }
        return res;
    }

    @Override
    public void complete(String name, Collection<SnapshotHandlerResult<Map<PartitionKeyV2, PartitionHashRecordV2>>> results) throws IgniteCheckedException {
        HashMap<PartitionKeyV2, List<PartitionHashRecordV2>> clusterHashes = new HashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
        HashMap<ClusterNode, Exception> errs = new HashMap<ClusterNode, Exception>();
        for (SnapshotHandlerResult<Map<PartitionKeyV2, PartitionHashRecordV2>> res : results) {
            if (res.error() != null) {
                errs.put(res.node(), res.error());
                continue;
            }
            for (Map.Entry<PartitionKeyV2, PartitionHashRecordV2> entry : res.data().entrySet()) {
                clusterHashes.computeIfAbsent(entry.getKey(), v -> new ArrayList()).add(entry.getValue());
            }
        }
        IdleVerifyResultV2 verifyResult = new IdleVerifyResultV2(clusterHashes, errs);
        if (errs.isEmpty() && !verifyResult.hasConflicts()) {
            return;
        }
        GridStringBuilder buf = new GridStringBuilder();
        verifyResult.print(buf::a, true);
        throw new IgniteCheckedException(buf.toString());
    }

    private static class SnapshotEncryptionKeyProvider
    implements EncryptionCacheKeyProvider {
        private final GridKernalContext ctx;
        private final Map<Integer, File> grpDirs;
        private final ConcurrentHashMap<Integer, GroupKey> decryptedKeys = new ConcurrentHashMap();

        private SnapshotEncryptionKeyProvider(GridKernalContext ctx, Map<Integer, File> grpDirs) {
            this.ctx = ctx;
            this.grpDirs = grpDirs;
        }

        @Override
        @Nullable
        public GroupKey getActiveKey(int grpId) {
            return this.decryptedKeys.computeIfAbsent(grpId, id -> {
                GroupKey grpKey = null;
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(this.grpDirs.get(grpId).toPath(), p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith("cache_data.dat"));){
                    for (Path p2 : ds) {
                        StoredCacheData cacheData = this.ctx.cache().configManager().readCacheData(p2.toFile());
                        GroupKeyEncrypted grpKeyEncrypted = cacheData.groupKeyEncrypted();
                        if (grpKeyEncrypted == null) {
                            GroupKey groupKey = null;
                            return groupKey;
                        }
                        if (grpKey == null) {
                            grpKey = new GroupKey(grpKeyEncrypted.id(), this.ctx.config().getEncryptionSpi().decryptKey(grpKeyEncrypted.key()));
                            continue;
                        }
                        assert (grpKey.equals(new GroupKey(grpKeyEncrypted.id(), this.ctx.config().getEncryptionSpi().decryptKey(grpKeyEncrypted.key()))));
                    }
                    Iterator<Path> iterator = grpKey;
                    return iterator;
                }
                catch (Exception e) {
                    throw new IgniteException("Unable to extract ciphered encryption key of cache group " + id + '.', e);
                }
            });
        }

        @Override
        @Nullable
        public GroupKey groupKey(int grpId, int keyId) {
            GroupKey key = this.getActiveKey(grpId);
            return key != null && key.id() == keyId ? key : null;
        }
    }
}

