/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.AbstractWalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SimpleSegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.P2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleSegmentLogicalRecordsIterator
extends AbstractWalRecordsIterator {
    private static final long serialVersionUID = 0L;
    private boolean segmentInitialized;
    private File archiveDir;
    private CIX1<WALRecord> advanceC;

    SingleSegmentLogicalRecordsIterator(@NotNull IgniteLogger log, @NotNull GridCacheSharedContext sharedCtx, @NotNull FileIOFactory ioFactory, int bufSize, long archivedSegIdx, File archiveDir, CIX1<WALRecord> advanceC) throws IgniteCheckedException {
        super(log, sharedCtx, SingleSegmentLogicalRecordsIterator.initLogicalRecordsSerializerFactory(sharedCtx), ioFactory, bufSize, new SimpleSegmentFileInputFactory());
        this.curWalSegmIdx = archivedSegIdx;
        this.archiveDir = archiveDir;
        this.advanceC = advanceC;
        this.advance();
    }

    private static RecordSerializerFactory initLogicalRecordsSerializerFactory(GridCacheSharedContext sharedCtx) throws IgniteCheckedException {
        return new RecordSerializerFactoryImpl(sharedCtx, new LogicalRecordsFilter()).marshalledMode(true);
    }

    @Override
    protected AbstractWalRecordsIterator.AbstractReadFileHandle advanceSegment(@Nullable AbstractWalRecordsIterator.AbstractReadFileHandle curWalSegment) throws IgniteCheckedException {
        if (this.segmentInitialized) {
            this.closeCurrentWalSegment();
            return null;
        }
        this.segmentInitialized = true;
        FileDescriptor fd = new FileDescriptor(new File(this.archiveDir, FileDescriptor.fileName(this.curWalSegmIdx)));
        try {
            return this.initReadHandle(fd, null);
        }
        catch (FileNotFoundException e) {
            throw new IgniteCheckedException("Missing WAL segment in the archive", e);
        }
    }

    @Override
    protected void advance() throws IgniteCheckedException {
        super.advance();
        if (this.curRec != null && this.advanceC != null) {
            this.advanceC.apply((WALRecord)this.curRec.get2());
        }
    }

    @Override
    protected AbstractWalRecordsIterator.AbstractReadFileHandle createReadFileHandle(SegmentIO fileIO, RecordSerializer ser, FileInput in) {
        return new FileWriteAheadLogManager.ReadFileHandle(fileIO, ser, in, null);
    }

    private static class LogicalRecordsFilter
    implements P2<WALRecord.RecordType, WALPointer> {
        private static final long serialVersionUID = 0L;

        private LogicalRecordsFilter() {
        }

        @Override
        public boolean apply(WALRecord.RecordType type, WALPointer ptr) {
            return type.purpose() == WALRecord.RecordPurpose.LOGICAL || type == WALRecord.RecordType.CHECKPOINT_RECORD;
        }
    }
}

