/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.TransactionStateChangedEvent;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.discovery.ConsistentIdMapper;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheLazyEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxState;
import org.apache.ignite.internal.processors.cache.transactions.TransactionEventProxyImpl;
import org.apache.ignite.internal.processors.cache.transactions.TxCounters;
import org.apache.ignite.internal.processors.cache.version.GridCacheLazyPlainVersionedEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntryEx;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.GridSetWrapper;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridMetadataAwareAdapter;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public abstract class IgniteTxAdapter
extends GridMetadataAwareAdapter
implements IgniteInternalTx {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static final AtomicReferenceFieldUpdater<IgniteTxAdapter, IgniteInternalTx.FinalizationStatus> FINALIZING_UPD = AtomicReferenceFieldUpdater.newUpdater(IgniteTxAdapter.class, IgniteInternalTx.FinalizationStatus.class, "finalizing");
    private static final AtomicReferenceFieldUpdater<IgniteTxAdapter, TxCounters> TX_COUNTERS_UPD = AtomicReferenceFieldUpdater.newUpdater(IgniteTxAdapter.class, TxCounters.class, "txCounters");
    protected static IgniteLogger log;
    @GridToStringInclude
    protected GridCacheVersion xidVer;
    @GridToStringInclude
    protected GridCacheVersion writeVer;
    @GridToStringInclude
    protected boolean implicit;
    @GridToStringInclude
    protected boolean loc;
    @GridToStringInclude
    protected long threadId;
    @GridToStringInclude
    protected long startTime = U.currentTimeMillis();
    protected long startTimeNanos;
    @GridToStringInclude
    protected UUID nodeId;
    @GridToStringExclude
    protected GridCacheSharedContext<?, ?> cctx;
    protected boolean needRetVal;
    @GridToStringInclude
    protected TransactionIsolation isolation = TransactionIsolation.READ_COMMITTED;
    @GridToStringInclude
    protected TransactionConcurrency concurrency = TransactionConcurrency.PESSIMISTIC;
    @GridToStringInclude
    protected long timeout;
    @GridToStringExclude
    protected IgniteUuid deploymentLdrId;
    protected volatile boolean invalidate;
    private boolean sysInvalidate;
    protected boolean internal;
    private boolean sys;
    private byte plc;
    protected boolean onePhaseCommit;
    private volatile GridCacheVersion commitVer;
    private volatile IgniteInternalTx.FinalizationStatus finalizing = IgniteInternalTx.FinalizationStatus.NONE;
    protected volatile boolean isDone;
    @GridToStringInclude
    private Map<Integer, Set<Integer>> invalidParts;
    @GridToStringInclude
    private volatile TransactionState state = TransactionState.ACTIVE;
    private volatile boolean timedOut;
    protected int txSize;
    @GridToStringExclude
    private volatile GridFutureAdapter<IgniteInternalTx> finFut;
    @GridToStringInclude
    protected volatile AffinityTopologyVersion topVer = AffinityTopologyVersion.NONE;
    protected Map<UUID, Collection<UUID>> txNodes;
    protected UUID subjId;
    protected int taskNameHash;
    protected final String taskName;
    protected boolean storeEnabled = true;
    protected ConsistentIdMapper consistentIdMapper;
    @GridToStringInclude
    protected volatile MvccSnapshot mvccSnapshot;
    private boolean skipCompletedVers;
    @GridToStringExclude
    private volatile IgniteInternalFuture rollbackFut;
    @GridToStringExclude
    private volatile TxCounters txCounters;
    private GridNearTxLocal parentTx;

    protected IgniteTxAdapter(GridCacheSharedContext<?, ?> cctx, GridCacheVersion xidVer, boolean implicit, boolean loc, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, boolean invalidate, boolean storeEnabled, boolean onePhaseCommit, int txSize, @Nullable UUID subjId, int taskNameHash) {
        assert (xidVer != null);
        assert (cctx != null);
        this.cctx = cctx;
        this.xidVer = xidVer;
        this.implicit = implicit;
        this.loc = loc;
        this.sys = sys;
        this.plc = plc;
        this.concurrency = concurrency;
        this.isolation = isolation;
        this.timeout = timeout;
        this.invalidate = invalidate;
        this.storeEnabled = storeEnabled;
        this.onePhaseCommit = onePhaseCommit;
        this.txSize = txSize;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.deploymentLdrId = U.contextDeploymentClassLoaderId(cctx.kernalContext());
        this.nodeId = cctx.discovery().localNode().id();
        this.threadId = Thread.currentThread().getId();
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, this);
        }
        this.consistentIdMapper = new ConsistentIdMapper(cctx.discovery());
        boolean needTaskName = cctx.gridEvents().isRecordable(64) || cctx.gridEvents().isRecordable(63) || cctx.gridEvents().isRecordable(65);
        String string = this.taskName = needTaskName ? cctx.kernalContext().task().resolveTaskName(taskNameHash) : null;
        if (cctx.kernalContext().performanceStatistics().enabled()) {
            this.startTimeNanos = System.nanoTime();
        }
    }

    protected IgniteTxAdapter(GridCacheSharedContext<?, ?> cctx, UUID nodeId, GridCacheVersion xidVer, GridCacheVersion startVer, long threadId, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, int txSize, @Nullable UUID subjId, int taskNameHash) {
        this.cctx = cctx;
        this.nodeId = nodeId;
        this.threadId = threadId;
        this.xidVer = xidVer;
        this.sys = sys;
        this.plc = plc;
        this.concurrency = concurrency;
        this.isolation = isolation;
        this.timeout = timeout;
        this.txSize = txSize;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.implicit = false;
        this.loc = false;
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, this);
        }
        this.consistentIdMapper = new ConsistentIdMapper(cctx.discovery());
        boolean needTaskName = cctx.gridEvents().isRecordable(64) || cctx.gridEvents().isRecordable(63) || cctx.gridEvents().isRecordable(65);
        String string = this.taskName = needTaskName ? cctx.kernalContext().task().resolveTaskName(taskNameHash) : null;
        if (cctx.kernalContext().performanceStatistics().enabled()) {
            this.startTimeNanos = System.nanoTime();
        }
    }

    public void setParentTx(GridNearTxLocal parentTx) {
        this.parentTx = parentTx;
    }

    @Override
    @Nullable
    public MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    @Override
    public void mvccSnapshot(MvccSnapshot mvccSnapshot) {
        this.mvccSnapshot = mvccSnapshot;
    }

    public boolean skipCompletedVersions() {
        return this.skipCompletedVers;
    }

    public void skipCompletedVersions(boolean skipCompletedVers) {
        this.skipCompletedVers = skipCompletedVers;
    }

    public GridCacheSharedContext<?, ?> context() {
        return this.cctx;
    }

    @Override
    public boolean localResult() {
        assert (this.originatingNodeId() != null);
        return this.cctx.localNodeId().equals(this.originatingNodeId());
    }

    protected boolean updateNearCache(GridCacheContext<?, ?> cacheCtx, KeyCacheObject key, AffinityTopologyVersion topVer) {
        return false;
    }

    @Override
    public Collection<IgniteTxEntry> optimisticLockEntries() {
        if (this.serializable() && this.optimistic()) {
            return F.concat(false, this.writeEntries(), this.readEntries());
        }
        return this.writeEntries();
    }

    @Override
    public boolean storeEnabled() {
        return this.storeEnabled;
    }

    public void storeEnabled(boolean storeEnabled) {
        this.storeEnabled = storeEnabled;
    }

    @Override
    public boolean system() {
        return this.sys;
    }

    @Override
    public byte ioPolicy() {
        return this.plc;
    }

    @Override
    public boolean storeWriteThrough() {
        return this.storeEnabled() && this.txState().storeWriteThrough(this.cctx);
    }

    protected void uncommit() {
        for (IgniteTxEntry e : this.writeMap().values()) {
            try {
                GridCacheEntryEx entry = e.cached();
                if (e.op() == GridCacheOperation.NOOP) continue;
                entry.invalidate(this.xidVer);
            }
            catch (Throwable t) {
                U.error(log, "Failed to invalidate transaction entries while reverting a commit.", t);
                if (!(t instanceof Error)) break;
                throw (Error)t;
            }
        }
        this.cctx.tm().uncommitTx(this);
    }

    @Override
    public UUID otherNodeId() {
        return null;
    }

    @Override
    public UUID subjectId() {
        return this.subjId;
    }

    @Override
    public int taskNameHash() {
        return this.taskNameHash;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        AffinityTopologyVersion res = this.topVer;
        if (res == null || res.equals(AffinityTopologyVersion.NONE)) {
            AffinityTopologyVersion topVer;
            if (this.system() && (topVer = this.cctx.tm().lockedTopologyVersion(Thread.currentThread().getId(), this)) != null) {
                return topVer;
            }
            return this.cctx.exchange().readyAffinityVersion();
        }
        return res;
    }

    @Override
    public final AffinityTopologyVersion topologyVersionSnapshot() {
        AffinityTopologyVersion ret = this.topVer;
        return AffinityTopologyVersion.NONE.equals(ret) ? null : ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AffinityTopologyVersion topologyVersion(AffinityTopologyVersion topVer) {
        AffinityTopologyVersion topVer0 = this.topVer;
        if (!AffinityTopologyVersion.NONE.equals(topVer0)) {
            return topVer0;
        }
        IgniteTxAdapter igniteTxAdapter = this;
        synchronized (igniteTxAdapter) {
            topVer0 = this.topVer;
            if (AffinityTopologyVersion.NONE.equals(topVer0)) {
                this.topVer = topVer;
                return topVer;
            }
            return topVer0;
        }
    }

    @Override
    public final boolean markFinalizing(IgniteInternalTx.FinalizationStatus status) {
        boolean res;
        switch (status) {
            case USER_FINISH: {
                res = FINALIZING_UPD.compareAndSet(this, IgniteInternalTx.FinalizationStatus.NONE, status);
                break;
            }
            case RECOVERY_FINISH: {
                res = FINALIZING_UPD.compareAndSet(this, IgniteInternalTx.FinalizationStatus.NONE, status) || this.finalizing == status;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot set finalization status: " + (Object)((Object)status));
            }
        }
        if (res) {
            if (log.isDebugEnabled()) {
                log.debug("Marked transaction as finalized: " + this);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Transaction was not marked finalized: " + this);
        }
        return res;
    }

    @Override
    @Nullable
    public IgniteInternalTx.FinalizationStatus finalizationStatus() {
        return this.finalizing;
    }

    public abstract boolean isStarted();

    @Override
    public int size() {
        return this.txSize;
    }

    protected IgniteLogger log() {
        return log;
    }

    public boolean remote() {
        return false;
    }

    @Override
    public boolean near() {
        return false;
    }

    @Override
    public boolean implicit() {
        return this.implicit;
    }

    @Override
    public boolean implicitSingle() {
        return this.txState().implicitSingle();
    }

    @Override
    public boolean local() {
        return this.loc;
    }

    @Override
    public final boolean user() {
        return !this.implicit() && this.local() && !this.dht() && !this.internal();
    }

    @Override
    public boolean dht() {
        return false;
    }

    @Override
    public boolean colocated() {
        return false;
    }

    @Override
    public IgniteUuid xid() {
        return this.xidVer.asIgniteUuid();
    }

    @Override
    public Map<Integer, Set<Integer>> invalidPartitions() {
        return this.invalidParts == null ? Collections.emptyMap() : this.invalidParts;
    }

    @Override
    public void addInvalidPartition(int cacheId, int part) {
        Set<Integer> parts;
        if (this.invalidParts == null) {
            this.invalidParts = new HashMap<Integer, Set<Integer>>();
        }
        if ((parts = this.invalidParts.get(cacheId)) == null) {
            parts = new HashSet<Integer>();
            this.invalidParts.put(cacheId, parts);
        }
        parts.add(part);
        if (log.isDebugEnabled()) {
            log.debug("Added invalid partition for transaction [cacheId=" + cacheId + ", part=" + part + ", tx=" + this + ']');
        }
    }

    @Override
    public GridCacheVersion ownedVersion(IgniteTxKey key) {
        return null;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    public boolean needReturnValue() {
        return this.needRetVal;
    }

    public void needReturnValue(boolean needRetVal) {
        this.needRetVal = needRetVal;
    }

    public IgniteInternalFuture rollbackFuture() {
        return this.rollbackFut;
    }

    public void rollbackFuture(IgniteInternalFuture fut) {
        this.rollbackFut = fut;
    }

    @Override
    public long remainingTime() {
        if (this.timeout() <= 0L) {
            return 0L;
        }
        long timeLeft = this.timeout() - (U.currentTimeMillis() - this.startTime());
        return timeLeft <= 0L ? -1L : timeLeft;
    }

    public final IgniteCheckedException timeoutException() {
        return new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + this.timeout() + ", tx=" + CU.txString(this) + ']');
    }

    public final IgniteCheckedException rollbackException() {
        return new IgniteTxRollbackCheckedException("Failed to finish transaction because it has been rolled back [timeout=" + this.timeout() + ", tx=" + CU.txString(this) + ']');
    }

    public final IgniteCheckedException heuristicException(Throwable ex) {
        return new IgniteTxHeuristicCheckedException("Committing a transaction has produced runtime exception", ex);
    }

    public void logTxFinishErrorSafe(@Nullable IgniteLogger log, boolean commit, Throwable e) {
        assert (e != null) : "Exception is expected";
        String fmt = "Failed completing the transaction: [commit=%s, tx=%s]";
        try {
            U.error(log, String.format("Failed completing the transaction: [commit=%s, tx=%s]", commit, this), e);
        }
        catch (Throwable e0) {
            e.addSuppressed(e0);
            U.error(log, String.format("Failed completing the transaction: [commit=%s, tx=%s]", commit, CU.txString(this)), e);
        }
    }

    @Override
    public GridCacheVersion xidVersion() {
        return this.xidVer;
    }

    @Override
    public long threadId() {
        return this.threadId;
    }

    @Override
    public UUID nodeId() {
        return this.nodeId;
    }

    @Override
    public TransactionIsolation isolation() {
        return this.isolation;
    }

    @Override
    public TransactionConcurrency concurrency() {
        return this.concurrency;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public long timeout(long timeout) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot change timeout after transaction has started: " + this);
        }
        long old = this.timeout;
        this.timeout = timeout;
        return old;
    }

    @Override
    public boolean ownsLock(GridCacheEntryEx entry) throws GridCacheEntryRemovedException {
        GridCacheVersion explicit;
        GridCacheContext cacheCtx = entry.context();
        IgniteTxEntry txEntry = this.entry(entry.txKey());
        GridCacheVersion gridCacheVersion = explicit = txEntry == null ? null : txEntry.explicitVersion();
        return this.local() && !cacheCtx.isDht() ? entry.lockedBy(this.xidVersion()) || explicit != null && entry.lockedBy(explicit) : !entry.hasLockCandidate(this.xidVersion()) || entry.lockedBy(this.xidVersion());
    }

    @Override
    public boolean ownsLockUnsafe(GridCacheEntryEx entry) {
        GridCacheVersion explicit;
        GridCacheContext cacheCtx = entry.context();
        IgniteTxEntry txEntry = this.entry(entry.txKey());
        GridCacheVersion gridCacheVersion = explicit = txEntry == null ? null : txEntry.explicitVersion();
        return this.local() && !cacheCtx.isDht() ? entry.lockedByUnsafe(this.xidVersion()) || explicit != null && entry.lockedByUnsafe(explicit) : !entry.hasLockCandidateUnsafe(this.xidVersion()) || entry.lockedByUnsafe(this.xidVersion());
    }

    @Override
    public TransactionState state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void errorWhenCommitting() {
        IgniteTxAdapter igniteTxAdapter = this;
        synchronized (igniteTxAdapter) {
            TransactionState prev = this.state;
            assert (prev == TransactionState.COMMITTING) : prev;
            this.state = TransactionState.MARKED_ROLLBACK;
            if (log.isDebugEnabled()) {
                log.debug("Changed transaction state [prev=" + (Object)((Object)prev) + ", new=" + (Object)((Object)this.state) + ", tx=" + this + ']');
            }
            this.notifyAll();
        }
    }

    @Override
    public boolean setRollbackOnly() {
        return this.state(TransactionState.MARKED_ROLLBACK);
    }

    @Override
    public boolean isRollbackOnly() {
        return this.state == TransactionState.MARKED_ROLLBACK || this.state == TransactionState.ROLLING_BACK || this.state == TransactionState.ROLLED_BACK;
    }

    @Override
    public boolean done() {
        return this.isDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setDone() {
        boolean isDone0 = this.isDone;
        if (isDone0) {
            return false;
        }
        IgniteTxAdapter igniteTxAdapter = this;
        synchronized (igniteTxAdapter) {
            isDone0 = this.isDone;
            if (isDone0) {
                return false;
            }
            this.isDone = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheVersion commitVersion() {
        GridCacheVersion commitVer0 = this.commitVer;
        if (commitVer0 != null) {
            return commitVer0;
        }
        IgniteTxAdapter igniteTxAdapter = this;
        synchronized (igniteTxAdapter) {
            commitVer0 = this.commitVer;
            if (commitVer0 != null) {
                return commitVer0;
            }
            this.commitVer = commitVer0 = this.xidVer;
            return commitVer0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitVersion(GridCacheVersion commitVer) {
        if (commitVer == null) {
            return;
        }
        GridCacheVersion commitVer0 = this.commitVer;
        if (commitVer0 != null) {
            return;
        }
        IgniteTxAdapter igniteTxAdapter = this;
        synchronized (igniteTxAdapter) {
            commitVer0 = this.commitVer;
            if (commitVer0 != null) {
                return;
            }
            this.commitVer = commitVer;
        }
    }

    @Override
    public boolean needsCompletedVersions() {
        return false;
    }

    @Override
    public void completedVersions(GridCacheVersion base, Collection<GridCacheVersion> committed, Collection<GridCacheVersion> txs) {
    }

    @Override
    public boolean internal() {
        return this.internal;
    }

    protected boolean checkInternal(IgniteTxKey key) {
        if (key.key().internal()) {
            this.internal = true;
            return true;
        }
        return false;
    }

    public void onePhaseCommit(boolean onePhaseCommit) {
        this.onePhaseCommit = onePhaseCommit;
    }

    @Override
    public boolean onePhaseCommit() {
        return this.onePhaseCommit;
    }

    @Override
    public boolean optimistic() {
        return this.concurrency == TransactionConcurrency.OPTIMISTIC;
    }

    @Override
    public boolean pessimistic() {
        return this.concurrency == TransactionConcurrency.PESSIMISTIC;
    }

    @Override
    public boolean serializable() {
        return this.isolation == TransactionIsolation.SERIALIZABLE;
    }

    @Override
    public boolean repeatableRead() {
        return this.isolation == TransactionIsolation.REPEATABLE_READ;
    }

    @Override
    public boolean readCommitted() {
        return this.isolation == TransactionIsolation.READ_COMMITTED;
    }

    @Override
    public boolean state(TransactionState state) {
        return this.state(state, false);
    }

    public boolean chainState(TransactionState state) {
        if (this.parentTx != null) {
            this.parentTx.state(state);
        }
        return this.state(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<IgniteInternalTx> finishFuture() {
        TxFinishFuture fut = this.finFut;
        if (fut == null) {
            IgniteTxAdapter igniteTxAdapter = this;
            synchronized (igniteTxAdapter) {
                fut = this.finFut;
                if (fut == null) {
                    this.finFut = fut = new TxFinishFuture(this);
                }
            }
        }
        assert (fut != null);
        if (this.isDone) {
            fut.onDone((IgniteInternalTx)this);
        }
        return fut;
    }

    @Override
    @Nullable
    public IgniteInternalFuture<?> currentPrepareFuture() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean state(TransactionState state, boolean timedOut) {
        GridFutureAdapter<IgniteInternalTx> fut;
        boolean valid = false;
        boolean notify = false;
        WALPointer ptr = null;
        IgniteTxAdapter igniteTxAdapter = this;
        synchronized (igniteTxAdapter) {
            TransactionState prev = this.state;
            switch (state) {
                case ACTIVE: {
                    valid = prev == TransactionState.SUSPENDED;
                    break;
                }
                case PREPARING: {
                    valid = prev == TransactionState.ACTIVE;
                    break;
                }
                case PREPARED: {
                    valid = prev == TransactionState.PREPARING;
                    break;
                }
                case COMMITTING: {
                    valid = prev == TransactionState.PREPARED;
                    break;
                }
                case UNKNOWN: {
                    if (this.setDone()) {
                        notify = true;
                    }
                    valid = prev == TransactionState.ROLLING_BACK || prev == TransactionState.COMMITTING;
                    break;
                }
                case COMMITTED: {
                    if (this.setDone()) {
                        notify = true;
                    }
                    valid = prev == TransactionState.COMMITTING;
                    break;
                }
                case ROLLED_BACK: {
                    if (this.setDone()) {
                        notify = true;
                    }
                    valid = prev == TransactionState.ROLLING_BACK;
                    break;
                }
                case MARKED_ROLLBACK: {
                    valid = prev == TransactionState.ACTIVE || prev == TransactionState.PREPARING || prev == TransactionState.PREPARED || prev == TransactionState.SUSPENDED;
                    break;
                }
                case ROLLING_BACK: {
                    valid = prev == TransactionState.ACTIVE || prev == TransactionState.MARKED_ROLLBACK || prev == TransactionState.PREPARING || prev == TransactionState.PREPARED || prev == TransactionState.SUSPENDED || prev == TransactionState.COMMITTING && this.local() && !this.dht();
                    break;
                }
                case SUSPENDED: {
                    boolean bl = valid = prev == TransactionState.ACTIVE;
                }
            }
            if (valid) {
                if (timedOut) {
                    this.timedOut = true;
                }
                this.state = state;
                if (log.isDebugEnabled()) {
                    log.debug("Changed transaction state [prev=" + (Object)((Object)prev) + ", new=" + (Object)((Object)this.state) + ", tx=" + this + ']');
                }
                this.recordStateChangedEvent(state);
                this.notifyAll();
            } else if (log.isDebugEnabled()) {
                log.debug("Invalid transaction state transition [invalid=" + (Object)((Object)state) + ", cur=" + (Object)((Object)this.state) + ", tx=" + this + ']');
            }
            if (valid) {
                if (state != TransactionState.ACTIVE && state != TransactionState.SUSPENDED) {
                    this.seal();
                }
                if (state == TransactionState.PREPARED || state == TransactionState.COMMITTED || state == TransactionState.ROLLED_BACK) {
                    this.cctx.tm().setMvccState(this, state);
                    ptr = this.cctx.tm().logTxRecord(this);
                }
            }
        }
        if (valid && ptr != null && (state == TransactionState.COMMITTED || state == TransactionState.ROLLED_BACK)) {
            try {
                this.cctx.wal().flush(ptr, false);
            }
            catch (IgniteCheckedException e) {
                String msg = "Failed to fsync ptr: " + ptr;
                U.error(log, msg, e);
                throw new IgniteException(msg, e);
            }
        }
        if (notify && (fut = this.finFut) != null) {
            fut.onDone(this);
        }
        return valid;
    }

    private void recordStateChangedEvent(TransactionState state) {
        if (!this.near() || !this.local()) {
            return;
        }
        switch (state) {
            case ACTIVE: {
                this.recordStateChangedEvent(133);
                break;
            }
            case COMMITTED: {
                this.recordStateChangedEvent(130);
                break;
            }
            case ROLLED_BACK: {
                this.recordStateChangedEvent(131);
                break;
            }
            case SUSPENDED: {
                this.recordStateChangedEvent(132);
            }
        }
    }

    protected void recordStateChangedEvent(int type) {
        assert (this.near() && this.local());
        GridEventStorageManager evtMgr = this.cctx.gridEvents();
        if (!this.system() && evtMgr.isRecordable(type)) {
            evtMgr.record(new TransactionStateChangedEvent(this.cctx.discovery().localNode(), "Transaction state changed.", type, new TransactionEventProxyImpl((GridNearTxLocal)this)));
        }
    }

    @Override
    public GridCacheVersion writeVersion() {
        return this.writeVer == null ? this.commitVersion() : this.writeVer;
    }

    @Override
    public void writeVersion(GridCacheVersion writeVer) {
        this.writeVer = writeVer;
    }

    @Override
    public boolean timedOut() {
        return this.timedOut;
    }

    @Override
    public void invalidate(boolean invalidate) {
        if (this.isStarted() && !this.dht()) {
            throw new IllegalStateException("Cannot change invalidation flag after transaction has started: " + this);
        }
        this.invalidate = invalidate;
    }

    @Override
    public boolean isInvalidate() {
        return this.invalidate;
    }

    @Override
    public final boolean isSystemInvalidate() {
        return this.sysInvalidate;
    }

    @Override
    public final void systemInvalidate(boolean sysInvalidate) {
        this.sysInvalidate = sysInvalidate;
    }

    @Override
    @Nullable
    public Map<UUID, Collection<UUID>> transactionNodes() {
        return this.txNodes;
    }

    public void transactionNodes(Map<UUID, Collection<UUID>> txNodes) {
        this.txNodes = txNodes;
    }

    @Override
    @Nullable
    public GridCacheVersion nearXidVersion() {
        return null;
    }

    protected boolean isWriteToStoreFromDhtValid(Collection<CacheStoreManager> stores) {
        if (stores != null && !stores.isEmpty()) {
            boolean exp = F.first(stores).isWriteToStoreFromDht();
            for (CacheStoreManager store : stores) {
                if (store.isWriteToStoreFromDht() == exp) continue;
                return false;
            }
        }
        return true;
    }

    protected void sessionEnd(Collection<CacheStoreManager> stores, boolean commit) throws IgniteCheckedException {
        Iterator<CacheStoreManager> it = stores.iterator();
        GridSetWrapper visited = new GridSetWrapper(new IdentityHashMap());
        while (it.hasNext()) {
            CacheStoreManager store = it.next();
            store.sessionEnd(this, commit, !it.hasNext(), !visited.add(store.store()));
        }
    }

    protected final void batchStoreCommit(Iterable<IgniteTxEntry> writeEntries) throws IgniteCheckedException {
        if (!this.storeEnabled() || this.internal() || !this.local() && this.near()) {
            return;
        }
        Collection<CacheStoreManager> stores = this.txState().stores(this.cctx);
        if (stores == null || stores.isEmpty()) {
            return;
        }
        assert (this.isWriteToStoreFromDhtValid(stores)) : "isWriteToStoreFromDht can't be different within one transaction";
        CacheStoreManager first = F.first(stores);
        boolean isWriteToStoreFromDht = first.isWriteToStoreFromDht();
        if ((this.local() || first.isLocal()) && (this.near() || isWriteToStoreFromDht)) {
            try {
                if (writeEntries != null) {
                    LinkedHashMap<KeyCacheObject, IgniteBiTuple<CacheObject, GridCacheVersion>> putMap = null;
                    ArrayList<KeyCacheObject> rmvCol = null;
                    CacheStoreManager writeStore = null;
                    boolean skipNonPrimary = this.near() && isWriteToStoreFromDht;
                    for (IgniteTxEntry e : writeEntries) {
                        boolean intercept;
                        boolean skip = e.skipStore();
                        if (!skip && skipNonPrimary) {
                            boolean bl = skip = e.cached().isNear() || e.cached().detached() || !e.context().affinity().primaryByPartition(e.cached().partition(), this.topologyVersion()).isLocal();
                        }
                        if (!skip && !this.local() && this.cctx.localStorePrimaryOnly()) {
                            skip = true;
                        }
                        if (skip) continue;
                        boolean bl = intercept = e.context().config().getInterceptor() != null;
                        if (intercept || !F.isEmpty(e.entryProcessors())) {
                            e.cached().unswap(false);
                        }
                        IgniteBiTuple<GridCacheOperation, CacheObject> res = this.applyTransformClosures(e, false, null);
                        GridCacheContext<CacheObject, CacheObject> cacheCtx = e.context();
                        GridCacheOperation op = res.get1();
                        KeyCacheObject key = e.key();
                        CacheObject val = res.get2();
                        GridCacheVersion ver = this.writeVersion();
                        if (op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE) {
                            if (rmvCol != null && !rmvCol.isEmpty()) {
                                assert (writeStore != null);
                                writeStore.removeAll(this, (Collection<? extends KeyCacheObject>)rmvCol);
                                rmvCol.clear();
                                writeStore = null;
                            }
                            if (writeStore != null && writeStore != cacheCtx.store()) {
                                if (putMap != null && !putMap.isEmpty()) {
                                    writeStore.putAll(this, (Map<? extends KeyCacheObject, IgniteBiTuple<? extends CacheObject, GridCacheVersion>>)putMap);
                                    putMap.clear();
                                }
                                writeStore = null;
                            }
                            if (intercept) {
                                Object interceptorVal = cacheCtx.config().getInterceptor().onBeforePut(new CacheLazyEntry((GridCacheContext)cacheCtx, key, e.cached().rawGet(), e.keepBinary()), cacheCtx.cacheObjectContext().unwrapBinaryIfNeeded(val, e.keepBinary(), false, null));
                                if (interceptorVal == null) continue;
                                val = cacheCtx.toCacheObject(cacheCtx.unwrapTemporary(interceptorVal));
                            }
                            if (writeStore == null) {
                                writeStore = cacheCtx.store();
                            }
                            if (!writeStore.isWriteThrough()) continue;
                            if (putMap == null) {
                                putMap = new LinkedHashMap<KeyCacheObject, IgniteBiTuple<CacheObject, GridCacheVersion>>(this.writeMap().size(), 1.0f);
                            }
                            putMap.put(key, F.t(val, ver));
                            continue;
                        }
                        if (op == GridCacheOperation.DELETE) {
                            IgniteBiTuple<Boolean, CacheObject> t;
                            if (putMap != null && !putMap.isEmpty()) {
                                assert (writeStore != null);
                                writeStore.putAll(this, (Map<? extends KeyCacheObject, IgniteBiTuple<? extends CacheObject, GridCacheVersion>>)putMap);
                                putMap.clear();
                                writeStore = null;
                            }
                            if (writeStore != null && writeStore != cacheCtx.store()) {
                                if (rmvCol != null && !rmvCol.isEmpty()) {
                                    writeStore.removeAll(this, (Collection<? extends KeyCacheObject>)rmvCol);
                                    rmvCol.clear();
                                }
                                writeStore = null;
                            }
                            if (intercept && cacheCtx.cancelRemove(t = cacheCtx.config().getInterceptor().onBeforeRemove(new CacheLazyEntry((GridCacheContext)cacheCtx, key, e.cached().rawGet(), e.keepBinary())))) continue;
                            if (writeStore == null) {
                                writeStore = cacheCtx.store();
                            }
                            if (!writeStore.isWriteThrough()) continue;
                            if (rmvCol == null) {
                                rmvCol = new ArrayList<KeyCacheObject>();
                            }
                            rmvCol.add(key);
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Ignoring NOOP entry for batch store commit: " + e);
                    }
                    if (putMap != null && !putMap.isEmpty()) {
                        assert (rmvCol == null || rmvCol.isEmpty());
                        assert (writeStore != null);
                        writeStore.putAll(this, (Map<? extends KeyCacheObject, IgniteBiTuple<? extends CacheObject, GridCacheVersion>>)putMap);
                    }
                    if (rmvCol != null && !rmvCol.isEmpty()) {
                        assert (putMap == null || putMap.isEmpty());
                        assert (writeStore != null);
                        writeStore.removeAll(this, (Collection<? extends KeyCacheObject>)rmvCol);
                    }
                }
                this.sessionEnd(stores, true);
            }
            catch (IgniteCheckedException ex) {
                this.commitError(ex);
                this.errorWhenCommitting();
                this.cctx.tm().removeCommittedTx(this);
                throw ex;
            }
            catch (Throwable ex) {
                this.commitError(ex);
                this.errorWhenCommitting();
                this.cctx.tm().removeCommittedTx(this);
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                throw new IgniteCheckedException("Failed to commit transaction to database: " + this, ex);
            }
            finally {
                if (this.isRollbackOnly()) {
                    this.sessionEnd(stores, false);
                }
            }
        } else {
            this.sessionEnd(stores, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IgniteBiTuple<GridCacheOperation, CacheObject> applyTransformClosures(IgniteTxEntry txEntry, boolean metrics, @Nullable GridCacheReturn ret) throws GridCacheEntryRemovedException, IgniteCheckedException {
        ExpiryPolicy expiry;
        GridCacheVersion ver;
        assert (txEntry.op() != GridCacheOperation.TRANSFORM || !F.isEmpty(txEntry.entryProcessors())) : txEntry;
        GridCacheContext<?, ?> cacheCtx = txEntry.context();
        assert (cacheCtx != null);
        if (this.isSystemInvalidate()) {
            return F.t(cacheCtx.writeThrough() ? GridCacheOperation.RELOAD : GridCacheOperation.DELETE, null);
        }
        if (F.isEmpty(txEntry.entryProcessors())) {
            if (ret != null) {
                ret.value(cacheCtx, txEntry.value(), txEntry.keepBinary(), U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
            }
            return F.t(txEntry.op(), txEntry.value());
        }
        T2<GridCacheOperation, CacheObject> calcVal = txEntry.entryProcessorCalculatedValue();
        if (calcVal != null) {
            return calcVal;
        }
        boolean recordEvt = this.cctx.gridEvents().isRecordable(64);
        boolean keepBinary = txEntry.keepBinary();
        CacheObject cacheVal = txEntry.hasValue() ? txEntry.value() : (txEntry.hasOldValue() ? txEntry.oldValue() : txEntry.cached().innerGet(null, this, false, metrics, recordEvt, recordEvt ? F.first(txEntry.entryProcessors()).get1() : null, this.resolveTaskName(), null, keepBinary));
        boolean modified = false;
        Object val = null;
        Object key = null;
        try {
            ver = txEntry.cached().version();
        }
        catch (GridCacheEntryRemovedException e) {
            assert (this.optimistic()) : txEntry;
            if (log.isDebugEnabled()) {
                log.debug("Failed to get entry version: [msg=" + e.getMessage() + ']');
            }
            ver = null;
        }
        for (T2<EntryProcessor<Object, Object, Object>, Object[]> t : txEntry.entryProcessors()) {
            CacheInvokeEntry<Object, Object> invokeEntry = new CacheInvokeEntry<Object, Object>(txEntry.key(), key, cacheVal, val, ver, keepBinary, txEntry.cached());
            Object procRes = null;
            Exception err = null;
            IgniteThread.onEntryProcessorEntered(true);
            try {
                EntryProcessor processor = (EntryProcessor)t.get1();
                procRes = processor.process(invokeEntry, (Object[])t.get2());
                val = invokeEntry.getValue();
                key = invokeEntry.key();
            }
            catch (Exception e) {
                err = e;
            }
            finally {
                IgniteThread.onEntryProcessorLeft();
            }
            if (ret != null) {
                if (err != null || procRes != null) {
                    ret.addEntryProcessResult(txEntry.context(), txEntry.key(), null, procRes, err, keepBinary);
                } else {
                    ret.invokeResult(true);
                }
            }
            modified |= invokeEntry.modified();
        }
        if (modified) {
            cacheVal = cacheCtx.toCacheObject(cacheCtx.unwrapTemporary(val));
        }
        GridCacheOperation op = modified ? (cacheVal == null ? GridCacheOperation.DELETE : GridCacheOperation.UPDATE) : GridCacheOperation.NOOP;
        txEntry.entryProcessorCalculatedValue(new T2<GridCacheOperation, CacheObject>(op, op == GridCacheOperation.NOOP ? null : cacheVal));
        if (op == GridCacheOperation.NOOP && (expiry = cacheCtx.expiryForTxEntry(txEntry)) != null) {
            long ttl = CU.toTtl(expiry.getExpiryForAccess());
            txEntry.ttl(ttl);
            if (ttl == -2L) {
                op = GridCacheOperation.DELETE;
            }
        }
        return F.t(op, cacheVal);
    }

    public String resolveTaskName() {
        return this.taskName;
    }

    protected IgniteBiTuple<GridCacheOperation, GridCacheVersionConflictContext> conflictResolve(GridCacheOperation op, IgniteTxEntry txEntry, CacheObject newVal, GridCacheVersion newVer, GridCacheEntryEx old) throws IgniteCheckedException, GridCacheEntryRemovedException {
        ExpiryPolicy expiry;
        assert (newVer != null);
        long newTtl = txEntry.ttl();
        long newExpireTime = txEntry.conflictExpireTime();
        if (newTtl == -1L && (expiry = txEntry.context().expiryForTxEntry(txEntry)) != null) {
            if (op == GridCacheOperation.CREATE) {
                newTtl = CU.toTtl(expiry.getExpiryForCreation());
            } else if (op == GridCacheOperation.UPDATE) {
                newTtl = CU.toTtl(expiry.getExpiryForUpdate());
            }
        }
        if (newTtl == -2L) {
            op = GridCacheOperation.DELETE;
            newTtl = 0L;
        }
        if (newTtl == -1L) {
            if (old.isNewLocked()) {
                newTtl = 0L;
            } else {
                newTtl = old.rawTtl();
                newExpireTime = old.rawExpireTime();
            }
        }
        assert (newTtl != -2L && newTtl != -1L);
        if (newExpireTime == -1L) {
            newExpireTime = CU.toExpireTime(newTtl);
        }
        assert (newExpireTime != -1L);
        GridCacheVersionedEntryEx oldEntry = old.versionedEntry(txEntry.keepBinary());
        GridCacheContext<?, ?> entryCtx = txEntry.context();
        GridCacheLazyPlainVersionedEntry newEntry = new GridCacheLazyPlainVersionedEntry(entryCtx, txEntry.key(), newVal, newTtl, newExpireTime, newVer, false, txEntry.keepBinary());
        GridCacheVersionConflictContext ctx = old.context().conflictResolve(oldEntry, newEntry, false);
        if (ctx.isMerge()) {
            Object resVal = ctx.mergeValue();
            if ((op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE) && resVal == null) {
                op = GridCacheOperation.DELETE;
            } else if (op == GridCacheOperation.DELETE && resVal != null) {
                op = old.isNewLocked() ? GridCacheOperation.CREATE : GridCacheOperation.UPDATE;
            }
        }
        return F.t(op, ctx);
    }

    protected boolean isNearLocallyMapped(IgniteTxEntry e, boolean primaryOnly) {
        UUID nodeId;
        GridCacheContext<?, ?> cacheCtx = e.context();
        if (!cacheCtx.isNear()) {
            return false;
        }
        UUID uUID = e.nodeId() == null ? (this.local() ? this.nodeId : null) : (nodeId = e.nodeId());
        if (nodeId != null && nodeId.equals(this.cctx.localNodeId())) {
            return true;
        }
        GridCacheEntryEx cached = e.cached();
        int part = cached != null ? cached.partition() : cacheCtx.affinity().partition(e.key());
        List<ClusterNode> affNodes = cacheCtx.affinity().nodesByPartition(part, this.topologyVersion());
        e.locallyMapped(F.contains(affNodes, this.cctx.localNode()));
        if (primaryOnly) {
            ClusterNode primary = F.first(affNodes);
            if (primary == null && !cacheCtx.affinityNode()) {
                return false;
            }
            assert (primary != null) : "Primary node is null for affinity nodes: " + affNodes;
            return primary.isLocal();
        }
        return e.locallyMapped();
    }

    protected boolean evictNearEntry(IgniteTxEntry e, boolean primaryOnly) {
        assert (e != null);
        if (this.isNearLocallyMapped(e, primaryOnly)) {
            GridCacheEntryEx cached = e.cached();
            assert (cached instanceof GridNearCacheEntry) : "Invalid cache entry: " + e;
            if (log.isDebugEnabled()) {
                log.debug("Evicting dht-local entry from near cache [entry=" + cached + ", tx=" + this + ']');
            }
            if (cached != null && cached.markObsolete(this.xidVer)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof IgniteTxAdapter && this.xidVer.equals(((IgniteTxAdapter)o).xidVer);
    }

    public int hashCode() {
        return this.xidVer.hashCode();
    }

    public abstract void addActiveCache(GridCacheContext var1, boolean var2) throws IgniteCheckedException;

    @Override
    public TxCounters txCounters(boolean createIfAbsent) {
        if (createIfAbsent && this.txCounters == null) {
            TX_COUNTERS_UPD.compareAndSet(this, null, new TxCounters());
        }
        return this.txCounters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyTxSizes() {
        TxCounters txCntrs = this.txCounters(false);
        if (txCntrs == null) {
            return;
        }
        Map<Integer, Map<Integer, AtomicLong>> sizeDeltas = txCntrs.sizeDeltas();
        for (Map.Entry<Integer, Map<Integer, AtomicLong>> entry : sizeDeltas.entrySet()) {
            Integer cacheId = entry.getKey();
            Map<Integer, AtomicLong> deltas = entry.getValue();
            assert (!F.isEmpty(deltas));
            GridDhtPartitionTopology top = this.cctx.cacheContext(cacheId).topology();
            boolean reserve = this.dht() && this.remote();
            for (Map.Entry<Integer, AtomicLong> e : deltas.entrySet()) {
                int p;
                boolean invalid;
                block15: {
                    invalid = false;
                    p = e.getKey();
                    long delta = e.getValue().get();
                    try {
                        GridDhtLocalPartition part = top.localPartition(p);
                        if (!reserve || part != null && part.reserve()) {
                            assert (part != null);
                            try {
                                if (part.state() != GridDhtPartitionState.RENTING) {
                                    part.dataStore().updateSize(cacheId, delta);
                                } else {
                                    invalid = true;
                                }
                                break block15;
                            }
                            finally {
                                if (reserve) {
                                    part.release();
                                }
                            }
                        }
                        invalid = true;
                    }
                    catch (GridDhtInvalidPartitionException e1) {
                        invalid = true;
                    }
                }
                if (!invalid) continue;
                assert (reserve);
                if (!log.isDebugEnabled()) continue;
                log.debug("Trying to apply size delta for invalid partition: [cacheId=" + cacheId + ", part=" + p + "]");
            }
        }
    }

    public String toString() {
        return GridToStringBuilder.toString(IgniteTxAdapter.class, this, "duration", (Object)(U.currentTimeMillis() - this.startTime + "ms"), "onePhaseCommit", (Object)this.onePhaseCommit);
    }

    private static class TxFinishFuture
    extends GridFutureAdapter<IgniteInternalTx> {
        @GridToStringInclude
        private IgniteTxAdapter tx;
        private volatile long completionTime;

        private TxFinishFuture(IgniteTxAdapter tx) {
            this.tx = tx;
        }

        @Override
        public boolean onDone(@Nullable IgniteInternalTx res, @Nullable Throwable err) {
            this.completionTime = U.currentTimeMillis();
            return super.onDone(res, err);
        }

        @Override
        public String toString() {
            long ct = this.completionTime;
            if (ct == 0L) {
                ct = U.currentTimeMillis();
            }
            long duration = ct - this.tx.startTime();
            return S.toString(TxFinishFuture.class, this, "duration", (Object)duration);
        }
    }

    private static class TxShadow
    implements IgniteInternalTx {
        private final IgniteUuid xid;
        private final UUID nodeId;
        private final long threadId;
        private final long startTime;
        private final long startTimeNanos;
        private final TransactionIsolation isolation;
        private final TransactionConcurrency concurrency;
        private final boolean invalidate;
        private final long timeout;
        private final TransactionState state;
        private final boolean rollbackOnly;
        private final boolean implicit;

        TxShadow(IgniteUuid xid, UUID nodeId, long threadId, long startTime, long startTimeNanos, TransactionIsolation isolation, TransactionConcurrency concurrency, boolean invalidate, boolean implicit, long timeout, TransactionState state, boolean rollbackOnly) {
            this.xid = xid;
            this.nodeId = nodeId;
            this.threadId = threadId;
            this.startTime = startTime;
            this.startTimeNanos = startTimeNanos;
            this.isolation = isolation;
            this.concurrency = concurrency;
            this.invalidate = invalidate;
            this.implicit = implicit;
            this.timeout = timeout;
            this.state = state;
            this.rollbackOnly = rollbackOnly;
        }

        @Override
        public void mvccSnapshot(MvccSnapshot mvccSnapshot) {
        }

        @Override
        public MvccSnapshot mvccSnapshot() {
            return null;
        }

        @Override
        public boolean localResult() {
            return false;
        }

        @Override
        public IgniteUuid xid() {
            return this.xid;
        }

        @Override
        public UUID nodeId() {
            return this.nodeId;
        }

        @Override
        public long threadId() {
            return this.threadId;
        }

        @Override
        public long startTime() {
            return this.startTime;
        }

        @Override
        public long startTimeNanos() {
            return this.startTimeNanos;
        }

        @Override
        public TransactionIsolation isolation() {
            return this.isolation;
        }

        @Override
        public TransactionConcurrency concurrency() {
            return this.concurrency;
        }

        @Override
        public boolean isInvalidate() {
            return this.invalidate;
        }

        @Override
        public boolean implicit() {
            return this.implicit;
        }

        @Override
        public long timeout() {
            return this.timeout;
        }

        @Override
        public TransactionState state() {
            return this.state;
        }

        @Override
        public boolean isRollbackOnly() {
            return this.rollbackOnly;
        }

        @Override
        public long timeout(long timeout) {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public boolean setRollbackOnly() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public void errorWhenCommitting() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public boolean activeCachesDeploymentEnabled() {
            return false;
        }

        @Override
        public void activeCachesDeploymentEnabled(boolean depEnabled) {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Nullable
        public Object addMeta(int key, Object val) {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Nullable
        public Object removeMeta(int key) {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Nullable
        public Object meta(int key) {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public int size() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public boolean storeEnabled() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public boolean storeWriteThrough() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public boolean system() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public byte ioPolicy() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public AffinityTopologyVersion topologyVersion() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public AffinityTopologyVersion topologyVersionSnapshot() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public boolean implicitSingle() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public AffinityTopologyVersion topologyVersion(AffinityTopologyVersion topVer) {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public void commitError(Throwable e) {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        @Nullable
        public String label() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public boolean empty() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public boolean markFinalizing(IgniteInternalTx.FinalizationStatus status) {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        @Nullable
        public IgniteInternalTx.FinalizationStatus finalizationStatus() {
            return null;
        }

        @Override
        public void addInvalidPartition(int cacheId, int part) {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public Map<Integer, Set<Integer>> invalidPartitions() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        @Nullable
        public GridCacheVersion ownedVersion(IgniteTxKey key) {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        @Nullable
        public UUID otherNodeId() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public UUID eventNodeId() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        public UUID originatingNodeId() {
            throw new IllegalStateException("Deserialized transaction can only be used as read-only.");
        }

        @Override
        @Nullable
        public TxCounters txCounters(boolean createIfAbsent) {
            return null;
        }

        @Override
        public IgniteTxState txState() {
            return null;
        }

        @Override
        public Collection<UUID> masterNodeIds() {
            return null;
        }

        @Override
        @Nullable
        public GridCacheVersion nearXidVersion() {
            return null;
        }

        @Override
        @Nullable
        public Map<UUID, Collection<UUID>> transactionNodes() {
            return null;
        }

        @Override
        public boolean ownsLock(GridCacheEntryEx entry) throws GridCacheEntryRemovedException {
            return false;
        }

        @Override
        public boolean ownsLockUnsafe(GridCacheEntryEx entry) {
            return false;
        }

        @Override
        public boolean near() {
            return false;
        }

        @Override
        public boolean dht() {
            return false;
        }

        @Override
        public boolean colocated() {
            return false;
        }

        @Override
        public boolean local() {
            return false;
        }

        @Override
        public UUID subjectId() {
            return null;
        }

        @Override
        public int taskNameHash() {
            return 0;
        }

        @Override
        public boolean user() {
            return false;
        }

        @Override
        public boolean hasWriteKey(IgniteTxKey key) {
            return false;
        }

        @Override
        public Set<IgniteTxKey> readSet() {
            return null;
        }

        @Override
        public Set<IgniteTxKey> writeSet() {
            return null;
        }

        @Override
        public Collection<IgniteTxEntry> allEntries() {
            return null;
        }

        @Override
        public Collection<IgniteTxEntry> writeEntries() {
            return null;
        }

        @Override
        public Collection<IgniteTxEntry> readEntries() {
            return null;
        }

        @Override
        public Map<IgniteTxKey, IgniteTxEntry> writeMap() {
            return null;
        }

        @Override
        public Map<IgniteTxKey, IgniteTxEntry> readMap() {
            return null;
        }

        @Override
        public Collection<IgniteTxEntry> optimisticLockEntries() {
            return null;
        }

        @Override
        public void seal() {
        }

        @Override
        @Nullable
        public IgniteTxEntry entry(IgniteTxKey key) {
            return null;
        }

        @Override
        @Nullable
        public GridTuple<CacheObject> peek(GridCacheContext ctx, boolean failFast, KeyCacheObject key) {
            return null;
        }

        @Override
        public GridCacheVersion xidVersion() {
            return null;
        }

        @Override
        public GridCacheVersion commitVersion() {
            return null;
        }

        @Override
        public void commitVersion(GridCacheVersion commitVer) {
        }

        @Override
        public IgniteInternalFuture<?> salvageTx() {
            return null;
        }

        @Override
        public GridCacheVersion writeVersion() {
            return null;
        }

        @Override
        public void writeVersion(GridCacheVersion ver) {
        }

        @Override
        public IgniteInternalFuture<IgniteInternalTx> finishFuture() {
            return null;
        }

        @Nullable
        public IgniteInternalFuture<IgniteInternalTx> currentPrepareFuture() {
            return null;
        }

        @Override
        public boolean state(TransactionState state) {
            return false;
        }

        @Override
        public void invalidate(boolean invalidate) {
        }

        @Override
        public void systemInvalidate(boolean sysInvalidate) {
        }

        @Override
        public boolean isSystemInvalidate() {
            return false;
        }

        @Override
        public IgniteInternalFuture<IgniteInternalTx> rollbackAsync() {
            return null;
        }

        @Override
        public IgniteInternalFuture<IgniteInternalTx> commitAsync() {
            return null;
        }

        @Override
        public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
            return false;
        }

        @Override
        public boolean timedOut() {
            return false;
        }

        @Override
        public boolean done() {
            return false;
        }

        @Override
        public boolean optimistic() {
            return false;
        }

        @Override
        public boolean pessimistic() {
            return false;
        }

        @Override
        public boolean readCommitted() {
            return false;
        }

        @Override
        public boolean repeatableRead() {
            return false;
        }

        @Override
        public boolean serializable() {
            return false;
        }

        @Override
        public long remainingTime() throws IgniteTxTimeoutCheckedException {
            return 0L;
        }

        @Override
        public Collection<GridCacheVersion> alternateVersions() {
            return null;
        }

        @Override
        public boolean needsCompletedVersions() {
            return false;
        }

        public void completedVersions(GridCacheVersion base, Collection committed, Collection rolledback) {
        }

        @Override
        public boolean internal() {
            return false;
        }

        @Override
        public boolean onePhaseCommit() {
            return false;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof IgniteInternalTx && this.xid.equals(((IgniteInternalTx)o).xid());
        }

        public int hashCode() {
            return this.xid.hashCode();
        }

        public String toString() {
            return S.toString(TxShadow.class, this);
        }
    }
}

