/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.distributed;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.distributed.FullMessage;
import org.apache.ignite.internal.util.distributed.InitMessage;
import org.apache.ignite.internal.util.distributed.SingleNodeMessage;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI3;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class DistributedProcess<I extends Serializable, R extends Serializable> {
    private final DistributedProcessType type;
    private final ConcurrentHashMap<UUID, Process> processes = new ConcurrentHashMap(1);
    private final Object mux = new Object();
    private final GridKernalContext ctx;
    private final IgniteLogger log;
    private BiFunction<UUID, I, ? extends InitMessage<I>> initMsgFactory;

    public DistributedProcess(GridKernalContext ctx, DistributedProcessType type, Function<I, IgniteInternalFuture<R>> exec, CI3<UUID, Map<UUID, R>, Map<UUID, Exception>> finish) {
        this(ctx, type, exec, finish, (id, req) -> new InitMessage<Serializable>((UUID)id, type, (Serializable)req));
    }

    public DistributedProcess(GridKernalContext ctx, DistributedProcessType type, Function<I, IgniteInternalFuture<R>> exec, CI3<UUID, Map<UUID, R>, Map<UUID, Exception>> finish, BiFunction<UUID, I, ? extends InitMessage<I>> initMsgFactory) {
        this.ctx = ctx;
        this.type = type;
        this.initMsgFactory = initMsgFactory;
        this.log = ctx.log(this.getClass());
        ctx.discovery().setCustomEventListener(InitMessage.class, (topVer, snd, msg) -> {
            if (msg.type() != type.ordinal()) {
                return;
            }
            Process p = this.processes.computeIfAbsent(msg.processId(), id -> new Process(msg.processId()));
            if (p.initFut.isDone()) {
                return;
            }
            ClusterNode crd = this.coordinator();
            if (crd == null) {
                p.initFut.onDone();
                this.onAllServersLeft();
                return;
            }
            p.crdId = crd.id();
            if (crd.isLocal()) {
                this.initCoordinator(p, topVer);
            }
            IgniteInternalFuture fut = (IgniteInternalFuture)exec.apply(msg.request());
            fut.listen(f -> {
                if (f.error() != null) {
                    p.resFut.onDone(f.error());
                } else {
                    p.resFut.onDone(f.result());
                }
                if (!ctx.clientNode()) {
                    assert (crd != null);
                    this.sendSingleMessage(p);
                }
            });
            p.initFut.onDone();
        });
        ctx.discovery().setCustomEventListener(FullMessage.class, (topVer, snd, msg0) -> {
            if (msg0.type() != type.ordinal()) {
                return;
            }
            FullMessage msg = msg0;
            Process p = this.processes.get(msg.processId());
            if (p == null) {
                this.log.warning("Received the finish distributed process message for an uninitialized process (possible cause is message's double delivering) [msg=" + msg + ']');
                return;
            }
            finish.apply(p.id, msg.result(), msg.error());
            this.processes.remove(msg.processId());
        });
        ctx.io().addMessageListener(GridTopic.TOPIC_DISTRIBUTED_PROCESS, (nodeId, msg0, plc) -> {
            SingleNodeMessage msg;
            if (msg0 instanceof SingleNodeMessage && ((SingleNodeMessage)msg0).type() == type.ordinal() && (msg = (SingleNodeMessage)msg0).type() == type.ordinal()) {
                this.onSingleNodeMessageReceived(msg, nodeId);
            }
        });
        ctx.event().addDiscoveryEventListener((evt, discoCache) -> {
            UUID leftNodeId = evt.eventNode().id();
            for (Process p : this.processes.values()) {
                p.initFut.listen(fut -> {
                    if (F.eq(leftNodeId, p.crdId)) {
                        ClusterNode crd = this.coordinator();
                        if (crd == null) {
                            this.onAllServersLeft();
                            return;
                        }
                        p.crdId = crd.id();
                        if (crd.isLocal()) {
                            this.initCoordinator(p, discoCache.version());
                        }
                        if (!ctx.clientNode()) {
                            p.resFut.listen(f -> this.sendSingleMessage(p));
                        }
                    } else if (F.eq(ctx.localNodeId(), p.crdId)) {
                        boolean isEmpty = false;
                        Object object = this.mux;
                        synchronized (object) {
                            if (p.remaining.remove(leftNodeId)) {
                                isEmpty = p.remaining.isEmpty();
                            }
                        }
                        if (isEmpty) {
                            this.finishProcess(p);
                        }
                    }
                });
            }
        }, 12, 11);
    }

    public void start(UUID id, I req) {
        try {
            this.ctx.discovery().sendCustomEvent(this.initMsgFactory.apply(id, req));
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Unable to start process.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCoordinator(Process p, AffinityTopologyVersion topVer) {
        Object object = this.mux;
        synchronized (object) {
            if (p.initCrdFut.isDone()) {
                return;
            }
            assert (p.remaining.isEmpty());
            p.remaining.addAll(F.viewReadOnly(this.ctx.discovery().serverNodes(topVer), F.node2id(), new IgnitePredicate[0]));
            p.initCrdFut.onDone();
        }
    }

    private void sendSingleMessage(Process p) {
        assert (p.resFut.isDone());
        SingleNodeMessage<Serializable> singleMsg = new SingleNodeMessage<Serializable>(p.id, this.type, (Serializable)p.resFut.result(), (Exception)p.resFut.error());
        UUID crdId = p.crdId;
        if (F.eq(this.ctx.localNodeId(), crdId)) {
            this.onSingleNodeMessageReceived(singleMsg, crdId);
        } else {
            try {
                this.ctx.io().sendToGridTopic(crdId, GridTopic.TOPIC_DISTRIBUTED_PROCESS, singleMsg, (byte)2);
            }
            catch (ClusterTopologyCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to send a single message to coordinator: [crdId=" + crdId + ", processId=" + p.id + ", error=" + e.getMessage() + ']');
                }
            }
            catch (IgniteCheckedException e) {
                this.log.error("Unable to send message to coordinator.", e);
                this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, new Exception("Unable to send message to coordinator.", e)));
            }
        }
    }

    private void onSingleNodeMessageReceived(SingleNodeMessage<R> msg, UUID nodeId) {
        Process p = this.processes.computeIfAbsent(msg.processId(), id -> new Process(msg.processId()));
        p.initCrdFut.listen(f -> {
            boolean isEmpty;
            Object object = this.mux;
            synchronized (object) {
                if (p.remaining.remove(nodeId)) {
                    p.singleMsgs.put(nodeId, msg);
                }
                isEmpty = p.remaining.isEmpty();
            }
            if (isEmpty) {
                this.finishProcess(p);
            }
        });
    }

    private void finishProcess(Process p) {
        HashMap res = new HashMap();
        HashMap<UUID, Exception> err = new HashMap<UUID, Exception>();
        p.singleMsgs.forEach((uuid, msg) -> {
            if (msg.hasError()) {
                err.put((UUID)uuid, msg.error());
            } else {
                res.put(uuid, msg.response());
            }
        });
        FullMessage msg2 = new FullMessage(p.id, this.type, res, err);
        try {
            this.ctx.discovery().sendCustomEvent(msg2);
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Unable to send action message.", e);
        }
    }

    private void onAllServersLeft() {
        this.processes.clear();
    }

    @Nullable
    private ClusterNode coordinator() {
        return U.oldest(this.ctx.discovery().aliveServerNodes(), null);
    }

    public static enum DistributedProcessType {
        TEST_PROCESS,
        MASTER_KEY_CHANGE_PREPARE,
        MASTER_KEY_CHANGE_FINISH,
        START_SNAPSHOT,
        END_SNAPSHOT,
        CACHE_GROUP_KEY_CHANGE_PREPARE,
        CACHE_GROUP_KEY_CHANGE_FINISH,
        PERFORMANCE_STATISTICS_ROTATE,
        RESTORE_CACHE_GROUP_SNAPSHOT_PREPARE,
        RESTORE_CACHE_GROUP_SNAPSHOT_PRELOAD,
        RESTORE_CACHE_GROUP_SNAPSHOT_START,
        RESTORE_CACHE_GROUP_SNAPSHOT_ROLLBACK;

    }

    private class Process {
        private final UUID id;
        private final GridFutureAdapter<Void> initCrdFut = new GridFutureAdapter();
        private volatile UUID crdId;
        private final GridFutureAdapter<Void> initFut = new GridFutureAdapter();
        private final Set<UUID> remaining = new GridConcurrentHashSet<UUID>();
        private final GridFutureAdapter<R> resFut = new GridFutureAdapter();
        private final ConcurrentHashMap<UUID, SingleNodeMessage<R>> singleMsgs = new ConcurrentHashMap();

        private Process(UUID id) {
            this.id = id;
        }
    }
}

