/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteTooManyOpenFilesException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.util.GridConcurrentFactory;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.nio.GridCommunicationClient;
import org.apache.ignite.internal.util.nio.GridTcpNioCommunicationClient;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.plugin.extensions.communication.MessageFormatter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.tcp.AttributeNames;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationMetricsListener;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.communication.tcp.internal.ClusterStateProvider;
import org.apache.ignite.spi.communication.tcp.internal.CommunicationTcpUtils;
import org.apache.ignite.spi.communication.tcp.internal.ConnectFuture;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionKey;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionRequestFuture;
import org.apache.ignite.spi.communication.tcp.internal.GridNioServerWrapper;
import org.apache.ignite.spi.communication.tcp.internal.NodeUnreachableException;
import org.apache.ignite.spi.communication.tcp.internal.TcpCommunicationConfiguration;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.jetbrains.annotations.Nullable;

public class ConnectionClientPool {
    private static final int CONNECTION_ESTABLISH_THRESHOLD_MS = 100;
    private final ConcurrentMap<UUID, GridCommunicationClient[]> clients = GridConcurrentFactory.newMap();
    private final TcpCommunicationConfiguration cfg;
    private final AttributeNames attrs;
    private final IgniteLogger log;
    @Nullable
    private volatile TcpCommunicationMetricsListener metricsLsnr;
    private final Supplier<ClusterNode> locNodeSupplier;
    private final Function<UUID, ClusterNode> nodeGetter;
    private final Supplier<MessageFormatter> msgFormatterSupplier;
    private final WorkersRegistry registry;
    private final TcpCommunicationSpi tcpCommSpi;
    private final ClusterStateProvider clusterStateProvider;
    private final GridNioServerWrapper nioSrvWrapper;
    private final ConcurrentMap<ConnectionKey, GridFutureAdapter<GridCommunicationClient>> clientFuts = GridConcurrentFactory.newMap();
    private volatile boolean stopping = false;
    private final ScheduledExecutorService handshakeTimeoutExecutorService;
    private boolean forcibleNodeKillEnabled = IgniteSystemProperties.getBoolean("IGNITE_ENABLE_FORCIBLE_NODE_KILL");

    public ConnectionClientPool(TcpCommunicationConfiguration cfg, AttributeNames attrs, IgniteLogger log, TcpCommunicationMetricsListener metricsLsnr, Supplier<ClusterNode> locNodeSupplier, Function<UUID, ClusterNode> nodeGetter, Supplier<MessageFormatter> msgFormatterSupplier, WorkersRegistry registry, TcpCommunicationSpi tcpCommSpi, ClusterStateProvider clusterStateProvider, GridNioServerWrapper nioSrvWrapper, String igniteInstanceName) {
        this.cfg = cfg;
        this.attrs = attrs;
        this.log = log;
        this.metricsLsnr = metricsLsnr;
        this.locNodeSupplier = locNodeSupplier;
        this.nodeGetter = nodeGetter;
        this.msgFormatterSupplier = msgFormatterSupplier;
        this.registry = registry;
        this.tcpCommSpi = tcpCommSpi;
        this.clusterStateProvider = clusterStateProvider;
        this.nioSrvWrapper = nioSrvWrapper;
        this.handshakeTimeoutExecutorService = Executors.newSingleThreadScheduledExecutor(new IgniteThreadFactory(igniteInstanceName, "handshake-timeout-client"));
    }

    public void stop() {
        this.stopping = true;
        for (GridFutureAdapter fut : this.clientFuts.values()) {
            if (!(fut instanceof ConnectionRequestFuture)) continue;
            fut.onDone(new IgniteSpiException("SPI is being stopped."));
        }
        this.handshakeTimeoutExecutorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public GridCommunicationClient reserveClient(ClusterNode node, int connIdx) throws IgniteCheckedException {
        if (!ConnectionClientPool.$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        if (!ConnectionClientPool.$assertionsDisabled && (connIdx < 0 || connIdx >= this.cfg.connectionsPerNode()) && this.cfg.usePairedConnections() && CommunicationTcpUtils.usePairedConnections(node, this.attrs.pairedConnection())) {
            throw new AssertionError(connIdx);
        }
        if (this.locNodeSupplier.get().isClient() && node.isClient() && TcpCommunicationSpi.DISABLED_CLIENT_PORT.equals(node.attribute(this.attrs.port()))) {
            throw new IgniteSpiException("Cannot send message to the client node with no server socket opened.");
        }
        nodeId = node.id();
        if (this.log.isDebugEnabled()) {
            this.log.debug("The node client is going to reserve a connection [nodeId=" + node.id() + ", connIdx=" + connIdx + "]");
        }
        while (true) {
            v0 = client = (curClients = (GridCommunicationClient[])this.clients.get(nodeId)) != null && connIdx < curClients.length ? curClients[connIdx] : null;
            if (client == null) {
                if (this.stopping) {
                    throw new IgniteSpiException("Node is stopping.");
                }
                connKey = new ConnectionKey(nodeId, connIdx, -1L);
                fut = new ConnectFuture();
                oldFut = this.clientFuts.putIfAbsent(connKey, fut);
                if (oldFut == null) {
                    try {
                        curClients0 = (GridCommunicationClient[])this.clients.get(nodeId);
                        v1 = client0 = curClients0 != null && connIdx < curClients0.length ? curClients0[connIdx] : null;
                        if (client0 == null) {
                            client0 = this.createCommunicationClient(node, connIdx);
                            if (client0 != null) {
                                this.addNodeClient(node, connIdx, client0);
                                if (client0 instanceof GridTcpNioCommunicationClient && (tcpClient = (GridTcpNioCommunicationClient)client0).session().closeTime() > 0L && this.removeNodeClient(nodeId, client0)) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Session was closed after client creation, will retry [node=" + node + ", client=" + client0 + ']');
                                    }
                                    client0 = null;
                                }
                            } else {
                                U.sleep(200L);
                                if (this.nodeGetter.apply(node.id()) == null) {
                                    throw new ClusterTopologyCheckedException("Failed to send message (node left topology): " + node);
                                }
                            }
                        }
                        fut.onDone(client0);
                    }
                    catch (NodeUnreachableException e) {
                        this.log.warning(e.getMessage());
                        fut = this.handleUnreachableNodeException(node, connIdx, fut, e);
                    }
                    catch (Throwable e) {
                        if (e instanceof NodeUnreachableException) {
                            throw e;
                        }
                        fut.onDone(e);
                        if (e instanceof IgniteTooManyOpenFilesException) {
                            throw e;
                        }
                        if (!(e instanceof Error)) ** GOTO lbl55
                        throw (Error)e;
                    }
                    finally {
                        this.clientFuts.remove(connKey, fut);
                    }
                } else {
                    fut = oldFut;
                }
lbl55:
                // 4 sources

                clientReserveWaitTimeout = this.registry != null ? this.registry.getSystemWorkerBlockedTimeout() / 3L : this.cfg.connectionTimeout() / 3L;
                currTimeout = System.currentTimeMillis();
                while (true) {
                    try {
                        client = (GridCommunicationClient)fut.get(clientReserveWaitTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (IgniteFutureTimeoutCheckedException ignored) {
                        currTimeout += clientReserveWaitTimeout;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Still waiting for reestablishing connection to node [nodeId=" + node.id() + ", waitingTime=" + currTimeout + "ms]");
                        }
                        if (this.registry == null || (wrkr = this.registry.worker(Thread.currentThread().getName())) == null) continue;
                        wrkr.updateHeartbeat();
                        continue;
                    }
                    break;
                }
                if (client == null) {
                    if (!this.clusterStateProvider.isLocalNodeDisconnected()) continue;
                    throw new IgniteCheckedException("Unable to create TCP client due to local node disconnecting.");
                }
                if (this.nodeGetter.apply(nodeId) == null) {
                    if (this.removeNodeClient(nodeId, client)) {
                        client.forceClose();
                    }
                    throw new IgniteSpiException("Destination node is not in topology: " + node.id());
                }
            }
            if (!ConnectionClientPool.$assertionsDisabled && connIdx != client.connectionIndex()) {
                throw new AssertionError(client);
            }
            if (client.reserve()) {
                return client;
            }
            this.removeNodeClient(nodeId, client);
        }
    }

    private GridFutureAdapter<GridCommunicationClient> handleUnreachableNodeException(ClusterNode node, int connIdx, GridFutureAdapter<GridCommunicationClient> fut, NodeUnreachableException e) throws IgniteCheckedException {
        if (this.cfg.connectionRequestor() != null) {
            ConnectFuture fut0 = (ConnectFuture)((Object)fut);
            ConnectionKey key = new ConnectionKey(node.id(), connIdx, -1L);
            ConnectionRequestFuture triggerFut = new ConnectionRequestFuture();
            triggerFut.listen(f -> {
                try {
                    fut0.onDone(f.get());
                }
                catch (Throwable t) {
                    fut0.onDone(t);
                }
                finally {
                    this.clientFuts.remove(key, triggerFut);
                }
            });
            this.clientFuts.put(key, triggerFut);
            fut = triggerFut;
            try {
                this.cfg.connectionRequestor().request(node, connIdx);
                long failTimeout = this.cfg.failureDetectionTimeoutEnabled() ? this.cfg.failureDetectionTimeout() : this.cfg.connectionTimeout();
                fut.get(failTimeout);
            }
            catch (Throwable triggerException) {
                if (this.forcibleNodeKillEnabled && node.isClient() && triggerException instanceof IgniteFutureTimeoutCheckedException) {
                    CommunicationTcpUtils.failNode(node, this.tcpCommSpi.getSpiContext(), triggerException, this.log);
                }
                IgniteSpiException spiE = new IgniteSpiException(e);
                spiE.addSuppressed(triggerException);
                String msg = "Failed to wait for establishing inverse communication connection from node " + node;
                this.log.warning(msg, spiE);
                fut.onDone(spiE);
                throw spiE;
            }
        } else {
            fut.onDone(e);
            throw new IgniteCheckedException(e);
        }
        return fut;
    }

    @Nullable
    public GridCommunicationClient createCommunicationClient(ClusterNode node, int connIdx) throws IgniteCheckedException {
        assert (node != null);
        ClusterNode locNode = this.locNodeSupplier.get();
        if (locNode == null) {
            throw new IgniteCheckedException("Failed to create NIO client (local node is stopping)");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating NIO client to node: " + node);
        }
        long start = System.currentTimeMillis();
        GridCommunicationClient client = this.nioSrvWrapper.createTcpClient(node, connIdx, true);
        long time = System.currentTimeMillis() - start;
        if (time > 100L) {
            if (this.log.isInfoEnabled()) {
                this.log.info("TCP client created [client=" + this.clientString(client, node) + ", duration=" + time + "ms]");
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("TCP client created [client=" + this.clientString(client, node) + ", duration=" + time + "ms]");
        }
        return client;
    }

    public String clientString(GridCommunicationClient client, ClusterNode node) throws IgniteCheckedException {
        if (client == null) {
            assert (node != null);
            StringJoiner joiner = new StringJoiner(", ", "null, node addrs=[", "]");
            for (InetSocketAddress addr : CommunicationTcpUtils.nodeAddresses(node, this.cfg.filterReachableAddresses(), this.attrs, this.locNodeSupplier)) {
                joiner.add(addr.toString());
            }
            return joiner.toString();
        }
        return client.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addNodeClient(ClusterNode node, int connIdx, GridCommunicationClient addClient) {
        assert (this.cfg.connectionsPerNode() > 0) : this.cfg.connectionsPerNode();
        assert (connIdx == addClient.connectionIndex()) : addClient;
        if (this.log.isDebugEnabled()) {
            this.log.debug("The node client is going to create a connection [nodeId=" + node.id() + ", connIdx=" + connIdx + ", client=" + addClient + "]");
        }
        if (connIdx >= this.cfg.connectionsPerNode()) {
            assert (!this.cfg.usePairedConnections() || !CommunicationTcpUtils.usePairedConnections(node, this.attrs.pairedConnection()));
            return;
        }
        while (true) {
            GridCommunicationClient[] newClients;
            GridCommunicationClient[] curClients = (GridCommunicationClient[])this.clients.get(node.id());
            assert (curClients == null || curClients[connIdx] == null) : "Client already created [node=" + node.id() + ", connIdx=" + connIdx + ", client=" + addClient + ", oldClient=" + curClients[connIdx] + ']';
            if (curClients == null) {
                newClients = new GridCommunicationClient[this.cfg.connectionsPerNode()];
                newClients[connIdx] = addClient;
                if (this.clients.putIfAbsent(node.id(), newClients) != null) continue;
                return;
            }
            newClients = (GridCommunicationClient[])curClients.clone();
            newClients[connIdx] = addClient;
            if (this.log.isDebugEnabled()) {
                this.log.debug("The node client was replaced [nodeId=" + node.id() + ", connIdx=" + connIdx + ", client=" + addClient + "]");
            }
            if (this.clients.replace(node.id(), curClients, newClients)) return;
        }
    }

    public boolean removeNodeClient(UUID nodeId, GridCommunicationClient rmvClient) {
        GridCommunicationClient[] newClients;
        GridCommunicationClient[] curClients;
        if (this.log.isDebugEnabled()) {
            this.log.debug("The client was removed [nodeId=" + nodeId + ",  client=" + rmvClient.toString() + "].");
        }
        do {
            if ((curClients = (GridCommunicationClient[])this.clients.get(nodeId)) == null || rmvClient.connectionIndex() >= curClients.length || curClients[rmvClient.connectionIndex()] != rmvClient) {
                return false;
            }
            newClients = Arrays.copyOf(curClients, curClients.length);
            newClients[rmvClient.connectionIndex()] = null;
        } while (!this.clients.replace(nodeId, curClients, newClients));
        return true;
    }

    public void forceCloseConnection(UUID nodeId) throws IgniteCheckedException {
        GridCommunicationClient[] clients;
        if (this.log.isDebugEnabled()) {
            this.log.debug("The node client connections were closed [nodeId=" + nodeId + "]");
        }
        if (Objects.nonNull(clients = (GridCommunicationClient[])this.clients.remove(nodeId))) {
            for (GridCommunicationClient client : clients) {
                client.forceClose();
            }
        }
        for (ConnectionKey connKey : this.clientFuts.keySet()) {
            GridFutureAdapter fut;
            if (!nodeId.equals(connKey.nodeId()) || !Objects.nonNull(fut = (GridFutureAdapter)this.clientFuts.remove(connKey))) continue;
            Optional.ofNullable(fut.get()).ifPresent(GridCommunicationClient::forceClose);
        }
    }

    public void onNodeLeft(UUID nodeId) {
        GridCommunicationClient[] clients0 = (GridCommunicationClient[])this.clients.remove(nodeId);
        if (clients0 != null) {
            for (GridCommunicationClient client : clients0) {
                if (client == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Forcing NIO client close since node has left [nodeId=" + nodeId + ", client=" + client + ']');
                }
                client.forceClose();
            }
        }
    }

    public GridCommunicationClient[] clientFor(UUID id) {
        return (GridCommunicationClient[])this.clients.get(id);
    }

    public Iterable<? extends Map.Entry<UUID, GridCommunicationClient[]>> entrySet() {
        return this.clients.entrySet();
    }

    public void removeFut(ConnectionKey connKey, GridFutureAdapter<GridCommunicationClient> fut) {
        this.clientFuts.remove(connKey, fut);
    }

    public GridFutureAdapter<GridCommunicationClient> getFut(ConnectionKey connKey) {
        return (GridFutureAdapter)this.clientFuts.get(connKey);
    }

    public GridFutureAdapter<GridCommunicationClient> putIfAbsentFut(ConnectionKey key, GridFutureAdapter<GridCommunicationClient> fut) {
        return this.clientFuts.putIfAbsent(key, fut);
    }

    public void forceClose() {
        Iterator iterator = this.clients.values().iterator();
        while (iterator.hasNext()) {
            GridCommunicationClient[] clients0;
            for (GridCommunicationClient client : clients0 = (GridCommunicationClient[])iterator.next()) {
                if (client == null) continue;
                client.forceClose();
            }
        }
    }

    public void completeFutures(IgniteClientDisconnectedCheckedException err) {
        for (GridFutureAdapter clientFut : this.clientFuts.values()) {
            clientFut.onDone(err);
        }
    }

    public void metricsListener(@Nullable TcpCommunicationMetricsListener metricsLsnr) {
        this.metricsLsnr = metricsLsnr;
    }
}

