/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import java.util.List;
import java.util.Objects;

public class DataFileInfo {
    private final String path;
    private final List<String> partitionValues;
    private final long size;
    private final DataFileType dataFileType;
    private final long creationTime;
    private final DeltaLakeJsonFileStatistics statistics;

    @JsonCreator
    public DataFileInfo(@JsonProperty(value="path") String path, @JsonProperty(value="size") long size, @JsonProperty(value="creationTime") long creationTime, @JsonProperty(value="fileType") DataFileType dataFileType, @JsonProperty(value="partitionValues") List<String> partitionValues, @JsonProperty(value="statistics") DeltaLakeJsonFileStatistics statistics) {
        this.path = path;
        this.size = size;
        this.creationTime = creationTime;
        this.dataFileType = Objects.requireNonNull(dataFileType, "dataFileType is null");
        this.partitionValues = partitionValues;
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty
    public long getCreationTime() {
        return this.creationTime;
    }

    @JsonProperty
    public DataFileType getDataFileType() {
        return this.dataFileType;
    }

    @JsonProperty
    public DeltaLakeJsonFileStatistics getStatistics() {
        return this.statistics;
    }

    public static enum DataFileType {
        DATA,
        CHANGE_DATA_FEED;

    }
}

