/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.trino.plugin.deltalake.DeltaLakeTableType;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeltaLakeTableName {
    private static final Pattern TABLE_PATTERN = Pattern.compile("(?<table>[^$@]+)(?:\\$(?<type>[^@]+))?");
    private final String tableName;
    private final DeltaLakeTableType tableType;

    public DeltaLakeTableName(String tableName, DeltaLakeTableType tableType) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
    }

    public String getTableName() {
        return this.tableName;
    }

    public DeltaLakeTableType getTableType() {
        return this.tableType;
    }

    public String getTableNameWithType() {
        return this.tableName + "$" + this.tableType.name().toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return this.getTableNameWithType();
    }

    public static DeltaLakeTableName from(String name) {
        Matcher match = TABLE_PATTERN.matcher(name);
        if (!match.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Delta Lake table name: " + name);
        }
        String table = match.group("table");
        String typeString = match.group("type");
        DeltaLakeTableType type = DeltaLakeTableType.DATA;
        if (typeString != null) {
            try {
                type = DeltaLakeTableType.valueOf(typeString.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Invalid Delta Lake table name (unknown type '%s'): %s", typeString, name));
            }
        }
        return new DeltaLakeTableName(table, type);
    }

    public static String tableNameFrom(String name) {
        Matcher match = TABLE_PATTERN.matcher(name);
        if (!match.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Delta Lake table name: " + name);
        }
        return match.group("table");
    }

    public static Optional<DeltaLakeTableType> tableTypeFrom(String name) {
        Matcher match = TABLE_PATTERN.matcher(name);
        if (!match.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Delta Lake table name: " + name);
        }
        String typeString = match.group("type");
        if (typeString == null) {
            return Optional.of(DeltaLakeTableType.DATA);
        }
        try {
            return Optional.of(DeltaLakeTableType.valueOf(typeString.toUpperCase(Locale.ENGLISH)));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static boolean isDataTable(String name) {
        Matcher match = TABLE_PATTERN.matcher(name);
        if (!match.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Delta Lake table name: " + name);
        }
        String typeString = match.group("type");
        if (typeString == null) {
            return true;
        }
        try {
            DeltaLakeTableType type = DeltaLakeTableType.valueOf(typeString.toUpperCase(Locale.ENGLISH));
            return type == DeltaLakeTableType.DATA;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

