/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Preconditions;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeMetadataFactory;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class DeltaLakeTransactionManager {
    private final DeltaLakeMetadataFactory metadataFactory;
    private final Map<ConnectorTransactionHandle, MemoizedMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, MemoizedMetadata>();

    @Inject
    public DeltaLakeTransactionManager(DeltaLakeMetadataFactory metadataFactory) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
    }

    public void begin(ConnectorTransactionHandle transaction) {
        MemoizedMetadata previousValue = this.transactions.putIfAbsent(transaction, new MemoizedMetadata());
        Preconditions.checkState((previousValue == null ? 1 : 0) != 0);
    }

    public DeltaLakeMetadata get(ConnectorTransactionHandle transaction, ConnectorIdentity identity) {
        return this.transactions.get(transaction).get(identity);
    }

    public void commit(ConnectorTransactionHandle transaction) {
        MemoizedMetadata deltaLakeMetadata = this.transactions.remove(transaction);
        Preconditions.checkArgument((deltaLakeMetadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        MemoizedMetadata transactionalMetadata = this.transactions.remove(transaction);
        Preconditions.checkArgument((transactionalMetadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        transactionalMetadata.optionalGet().ifPresent(metadata -> {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
                metadata.rollback();
            }
        });
    }

    private class MemoizedMetadata {
        @GuardedBy(value="this")
        private DeltaLakeMetadata metadata;

        private MemoizedMetadata() {
        }

        public synchronized Optional<DeltaLakeMetadata> optionalGet() {
            return Optional.ofNullable(this.metadata);
        }

        public synchronized DeltaLakeMetadata get(ConnectorIdentity identity) {
            if (this.metadata == null) {
                try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
                    this.metadata = DeltaLakeTransactionManager.this.metadataFactory.create(identity);
                }
            }
            return this.metadata;
        }
    }
}

