/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.expression;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.plugin.deltalake.expression.Literal;
import io.trino.plugin.deltalake.expression.SparkExpressionTreeVisitor;
import java.util.Locale;
import java.util.Objects;

public class BooleanLiteral
extends Literal {
    private final boolean value;

    public BooleanLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        Preconditions.checkArgument((value.toLowerCase(Locale.ENGLISH).equals("true") || value.toLowerCase(Locale.ENGLISH).equals("false") ? 1 : 0) != 0);
        this.value = value.toLowerCase(Locale.ENGLISH).equals("true");
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(SparkExpressionTreeVisitor<R, C> visitor, C context) {
        return visitor.visitBooleanLiteral(this, context);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanLiteral other = (BooleanLiteral)obj;
        return Objects.equals(this.value, other.value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.value).toString();
    }
}

