/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.statistics;

import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.plugin.deltalake.statistics.ExtendedStatistics;
import io.trino.plugin.deltalake.statistics.ExtendedStatisticsAccess;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public class MetaDirStatisticsAccess
implements ExtendedStatisticsAccess {
    private static final String STATISTICS_META_DIR = "_delta_log/_trino_meta";
    private static final String STATISTICS_FILE = "extended_stats.json";
    private static final String STARBURST_META_DIR = "_delta_log/_starburst_meta";
    private static final String STARBURST_STATISTICS_FILE = "extendeded_stats.json";
    private final TrinoFileSystemFactory fileSystemFactory;
    private final JsonCodec<ExtendedStatistics> statisticsCodec;

    @Inject
    public MetaDirStatisticsAccess(TrinoFileSystemFactory fileSystemFactory, JsonCodec<ExtendedStatistics> statisticsCodec) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.statisticsCodec = Objects.requireNonNull(statisticsCodec, "statisticsCodec is null");
    }

    @Override
    public Optional<ExtendedStatistics> readExtendedStatistics(ConnectorSession session, String tableLocation) {
        return this.readExtendedStatistics(session, tableLocation, STATISTICS_META_DIR, STATISTICS_FILE).or(() -> this.readExtendedStatistics(session, tableLocation, STARBURST_META_DIR, STARBURST_STATISTICS_FILE));
    }

    private Optional<ExtendedStatistics> readExtendedStatistics(ConnectorSession session, String tableLocation, String statisticsDirectory, String statisticsFile) {
        Optional<ExtendedStatistics> optional;
        block9: {
            Path statisticsPath = new Path(new Path(tableLocation, statisticsDirectory), statisticsFile);
            TrinoInputFile inputFile = this.fileSystemFactory.create(session).newInputFile(statisticsPath.toString());
            if (!inputFile.exists()) {
                return Optional.empty();
            }
            TrinoInputStream inputStream = inputFile.newStream();
            try {
                optional = Optional.of((ExtendedStatistics)this.statisticsCodec.fromJson(inputStream.readAllBytes()));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("failed to read statistics with table location %s", tableLocation), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return optional;
    }

    @Override
    public void updateExtendedStatistics(ConnectorSession session, String tableLocation, ExtendedStatistics statistics) {
        Path metaPath = new Path(tableLocation, STATISTICS_META_DIR);
        try {
            Path statisticsPath = new Path(metaPath, STATISTICS_FILE);
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            try (OutputStream outputStream = fileSystem.newOutputFile(statisticsPath.toString()).createOrOverwrite();){
                outputStream.write(this.statisticsCodec.toJsonBytes((Object)statistics));
            }
            String starburstStatisticsPath = new Path(new Path(tableLocation, STARBURST_META_DIR), STARBURST_STATISTICS_FILE).toString();
            if (fileSystem.newInputFile(starburstStatisticsPath).exists()) {
                fileSystem.deleteFile(new Path(new Path(tableLocation, STARBURST_META_DIR), STARBURST_STATISTICS_FILE).toString());
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("failed to store statistics with table location %s", tableLocation), (Throwable)e);
        }
    }

    @Override
    public void deleteExtendedStatistics(ConnectorSession session, String tableLocation) {
        Path statisticsPath = new Path(new Path(tableLocation, STATISTICS_META_DIR), STATISTICS_FILE);
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            if (fileSystem.newInputFile(statisticsPath.toString()).exists()) {
                fileSystem.deleteFile(statisticsPath.toString());
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error deleting statistics file %s", statisticsPath), (Throwable)e);
        }
    }
}

