/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DeltaLakeDataFileCacheEntry {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DeltaLakeDataFileCacheEntry.class);
    private final long version;
    private final List<AddFileEntry> activeFiles;
    private volatile long retainedSize = -1L;

    public DeltaLakeDataFileCacheEntry(long version, List<AddFileEntry> activeFiles) {
        this.version = version;
        this.activeFiles = ImmutableList.copyOf((Collection)Objects.requireNonNull(activeFiles, "activeFiles is null"));
    }

    public DeltaLakeDataFileCacheEntry withUpdatesApplied(List<DeltaLakeTransactionLogEntry> newEntries, long newVersion) {
        LinkedHashMap activeJsonEntries = new LinkedHashMap();
        HashSet removedFiles = new HashSet();
        newEntries.forEach(deltaLakeTransactionLogEntry -> {
            RemoveFileEntry removeEntry;
            AddFileEntry addEntry = deltaLakeTransactionLogEntry.getAdd();
            if (addEntry != null) {
                activeJsonEntries.put(addEntry.getPath(), addEntry);
            }
            if ((removeEntry = deltaLakeTransactionLogEntry.getRemove()) != null) {
                activeJsonEntries.remove(removeEntry.getPath());
                removedFiles.add(removeEntry.getPath());
            }
        });
        Stream<AddFileEntry> filteredExistingEntries = this.activeFiles.stream().filter(addEntry -> !removedFiles.contains(addEntry.getPath()) && !activeJsonEntries.containsKey(addEntry.getPath()));
        List updatedActiveFileList = (List)Stream.concat(filteredExistingEntries, activeJsonEntries.values().stream()).collect(ImmutableList.toImmutableList());
        return new DeltaLakeDataFileCacheEntry(newVersion, updatedActiveFileList);
    }

    public long getVersion() {
        return this.version;
    }

    public List<AddFileEntry> getActiveFiles() {
        return this.activeFiles;
    }

    public long getRetainedSizeInBytes() {
        if (this.retainedSize == -1L) {
            this.retainedSize = (long)INSTANCE_SIZE + this.activeFiles.stream().mapToLong(AddFileEntry::getRetainedSizeInBytes).sum();
        }
        return this.retainedSize;
    }
}

