/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.collect.ImmutableSet;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionEntry;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public class CheckpointEntries {
    private final MetadataEntry metadataEntry;
    private final ProtocolEntry protocolEntry;
    private final Set<TransactionEntry> transactionEntries;
    private final Set<AddFileEntry> addFileEntries;
    private final Set<RemoveFileEntry> removeFileEntries;

    CheckpointEntries(MetadataEntry metadataEntry, ProtocolEntry protocolEntry, Set<TransactionEntry> transactionEntries, Set<AddFileEntry> addFileEntries, Set<RemoveFileEntry> removeFileEntries) {
        this.metadataEntry = Objects.requireNonNull(metadataEntry, "metadataEntry is null");
        this.protocolEntry = Objects.requireNonNull(protocolEntry, "protocolEntry is null");
        this.transactionEntries = ImmutableSet.copyOf(transactionEntries);
        this.addFileEntries = ImmutableSet.copyOf(addFileEntries);
        this.removeFileEntries = ImmutableSet.copyOf(removeFileEntries);
    }

    public MetadataEntry getMetadataEntry() {
        return this.metadataEntry;
    }

    public ProtocolEntry getProtocolEntry() {
        return this.protocolEntry;
    }

    public Set<TransactionEntry> getTransactionEntries() {
        return this.transactionEntries;
    }

    public Set<AddFileEntry> getAddFileEntries() {
        return this.addFileEntries;
    }

    public Set<RemoveFileEntry> getRemoveFileEntries() {
        return this.removeFileEntries;
    }

    public BigInteger size() {
        return BigInteger.valueOf(this.transactionEntries.size() + this.addFileEntries.size() + this.removeFileEntries.size() + 2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointEntries that = (CheckpointEntries)o;
        return Objects.equals(this.metadataEntry, that.metadataEntry) && Objects.equals(this.protocolEntry, that.protocolEntry) && Objects.equals(this.transactionEntries, that.transactionEntries) && Objects.equals(this.addFileEntries, that.addFileEntries) && Objects.equals(this.removeFileEntries, that.removeFileEntries);
    }

    public int hashCode() {
        return Objects.hash(this.metadataEntry, this.protocolEntry, this.transactionEntries, this.addFileEntries, this.removeFileEntries);
    }

    public String toString() {
        return new StringJoiner(", ", CheckpointEntries.class.getSimpleName() + "[", "]").add("metadataEntry=" + this.metadataEntry).add("protocolEntry=" + this.protocolEntry).add("transactionEntries=" + this.transactionEntries).add("addFileEntries=" + this.addFileEntries).add("removeFileEntries=" + this.removeFileEntries).toString();
    }
}

