/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.airlift.slice;

import coral.shading.io.airlift.slice.Slice;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class Murmur3Hash32 {
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private static final int DEFAULT_SEED = 0;

    private Murmur3Hash32() {
    }

    public static int hash(Slice data) {
        return Murmur3Hash32.hash(data, 0, data.length());
    }

    public static int hash(Slice data, int offset, int length) {
        return Murmur3Hash32.hash(0, data, offset, length);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT", "SF_SWITCH_FALLTHROUGH"})
    public static int hash(int seed, Slice data, int offset, int length) {
        int k1;
        int current;
        int fastLimit = offset + length - 4 + 1;
        int h1 = seed;
        for (current = offset; current < fastLimit; current += 4) {
            k1 = Murmur3Hash32.mixK1(data.getInt(current));
            h1 = Murmur3Hash32.mixH1(h1, k1);
        }
        k1 = 0;
        switch (length & 3) {
            case 3: {
                k1 ^= data.getUnsignedByte(current + 2) << 16;
            }
            case 2: {
                k1 ^= data.getUnsignedByte(current + 1) << 8;
            }
            case 1: {
                k1 ^= data.getUnsignedByte(current + 0) << 0;
            }
        }
        return Murmur3Hash32.fmix(h1 ^= Murmur3Hash32.mixK1(k1), length);
    }

    public static int hash(int input) {
        int k1 = Murmur3Hash32.mixK1(input);
        int h1 = Murmur3Hash32.mixH1(0, k1);
        return Murmur3Hash32.fmix(h1, 4);
    }

    public static int hash(long input) {
        int low = (int)input;
        int high = (int)(input >>> 32);
        int k1 = Murmur3Hash32.mixK1(low);
        int h1 = Murmur3Hash32.mixH1(0, k1);
        k1 = Murmur3Hash32.mixK1(high);
        h1 = Murmur3Hash32.mixH1(h1, k1);
        return Murmur3Hash32.fmix(h1, 8);
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }
}

